/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.PojoCache;

public class SerializableObjectHandler {
    protected PojoCache cache_;
    protected InternalDelegate internal_;
    protected static final Log log = LogFactory.getLog((Class)SerializableObjectHandler.class);

    public SerializableObjectHandler(PojoCache cache, InternalDelegate internal) {
        this.cache_ = cache;
        this.internal_ = internal;
    }

    Object serializableObjectGet(Fqn fqn) throws CacheException {
        Object obj = this.internal_.get(fqn, "__SERIALIZED__");
        return obj;
    }

    protected boolean serializableObjectPut(Fqn fqn, Object obj) throws CacheException {
        if (obj instanceof Serializable || this.cache_.isMarshallNonSerializable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("putObject(): obj (" + obj.getClass() + ") is non-advisable but is Serializable. "));
            }
            this.putIntoCache(fqn, obj);
            return true;
        }
        return false;
    }

    protected void putIntoCache(Fqn fqn, Object obj) throws CacheException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        this.internal_.putAopClazz(fqn, obj.getClass(), map);
        AOPInstance aopInstance = new AOPInstance();
        aopInstance.set(obj);
        map.put(AOPInstance.KEY, aopInstance);
        map.put("__SERIALIZED__", obj);
        this.internal_.put(fqn, map);
    }

    protected boolean serializableObjectRemove(Fqn fqn) throws CacheException {
        return true;
    }
}

