/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.session.BaseSessionProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public abstract class BaseStatelessProxyFactory
extends BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatelessProxyFactory.class);

    protected Object constructProxy(InvocationHandler handler) {
        try {
            Object[] args = new Object[]{handler};
            Object proxy = this.proxyConstructor.newInstance(args);
            return proxy;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    public final Object createProxy(Object id) {
        assert (id == null) : "stateless bean must not have an id";
        return this.createProxy();
    }

    public void init() throws Exception {
        this.initializeJndiName();
        Class[] interfaces = this.getInterfaces();
        Class<?> proxyClass = Proxy.getProxyClass(this.getContainer().getBeanClass().getClassLoader(), interfaces);
        Class[] constructorParams = new Class[]{InvocationHandler.class};
        this.proxyConstructor = proxyClass.getConstructor(constructorParams);
    }

    public void start() throws Exception {
        this.init();
        Object proxy = this.createProxy();
        this.bindProxy(proxy);
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.getContainer().getInitialContext(), this.jndiName);
    }

    protected abstract void initializeJndiName();

    protected void bindProxy(Object proxy) throws NamingException {
        try {
            log.debug("Binding proxy for " + this.getContainer().getEjbName() + " in JNDI at " + this.jndiName);
            Util.rebind((Context)this.getContainer().getInitialContext(), this.jndiName, proxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateless proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName);
            namingException.setRootCause(e);
            throw namingException;
        }
    }
}

