/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.dgc.VMID;
import javax.ejb.EJBException;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.LocalProxy;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.logging.Logger;

public class StatefulLocalProxy
extends LocalProxy
implements Externalizable {
    private static final long serialVersionUID = 206913210970415540L;
    private static final Logger log = Logger.getLogger(StatefulLocalProxy.class);
    protected Object id;
    AsynchProvider provider;
    protected boolean isClustered = false;

    public StatefulLocalProxy(Container container, Object id, VMID vmid) {
        super(container);
        this.id = id;
        this.containerGuid = Ejb3Registry.guid(container, vmid);
        this.isClustered = ((StatefulContainer)container).isClustered();
    }

    public StatefulLocalProxy(AsynchProvider provider, Container container, Object id) {
        super(container);
        this.provider = provider;
        this.id = id;
        this.containerGuid = Ejb3Registry.guid(container);
        this.isClustered = ((StatefulContainer)container).isClustered();
    }

    public StatefulLocalProxy() {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.id = in.readObject();
        this.isClustered = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.id);
        out.writeBoolean(this.isClustered);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        Object ret = ProxyUtils.handleCallLocally(proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        Container container = Ejb3Registry.findContainer(this.containerGuid);
        if (this.isClustered && container == null && Ejb3Registry.hasClusterContainer(this.containerClusterUid)) {
            container = Ejb3Registry.getClusterContainer(this.containerClusterUid);
        }
        if (container == null) {
            throw new EJBException("Invalid (i.e. remote) invocation of local interface (null container) for " + this.containerGuid);
        }
        StatefulContainer sfsb = (StatefulContainer)container;
        return sfsb.localInvoke(this.id, method, args, (FutureHolder)((Object)this.provider));
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            StatefulLocalProxy handler = new StatefulLocalProxy(mixin, this.getContainer(), this.id);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        if (this.getContainer() != null && this.id != null) {
            return this.getContainer().getEjbName().toString() + ":" + this.id.toString();
        }
        return this.proxyName;
    }
}

