/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.factory;

import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorStringValueType;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoLocal;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoPK;
import com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoUtil;
import com.clustercontrol.snmp.util.RequestSnmp;
import com.clustercontrol.util.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorSnmpString
extends RunMonitorStringValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorSnmpString.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected static final ArrayList<String> m_attributeList = new ArrayList();
    protected MonitorSnmpInfoLocal m_snmp = null;
    protected RequestSnmp m_request = null;
    protected String m_communityName = null;
    protected int m_snmpPort = 161;
    protected int m_pollingTimeout = 1000;
    protected int m_pollingRetries = 3;
    protected String m_snmpOid = null;
    protected int m_snmpVersion = 1;
    protected String m_messageOrg = null;
    protected String m_messageId = "";
    protected String m_message = "";

    public RunMonitor createMonitorInstance() throws NamingException, JMSException, CreateException {
        return new RunMonitorSnmpString();
    }

    public boolean collect(String facilityId) {
        this.m_nodeDate = this.m_now.getTime();
        this.m_value = null;
        this.m_message = "";
        this.m_messageOrg = Messages.getString((String)"oid") + " : " + this.m_snmpOid;
        try {
            String ipNetworkNumber = null;
            try {
                HashMap facilityAttrMap = this.m_repository.getNodeDetail(facilityId, m_attributeList);
                Integer ipProtNum = (Integer)facilityAttrMap.get("ipProtocolNumber");
                ipNetworkNumber = ipProtNum != null && ipProtNum == 6 ? (String)facilityAttrMap.get("ccIpNetworkNumberV6") : (String)facilityAttrMap.get("ipNetworkNumber");
                Integer timeout = (Integer)facilityAttrMap.get("ccSnmpTimeout");
                if (timeout != null) {
                    m_log.debug((Object)("timeout   : " + timeout));
                    this.m_pollingTimeout = timeout;
                }
                Integer retries = (Integer)facilityAttrMap.get("ccSnmpRetries");
                m_log.debug((Object)("retries   : " + retries));
                if (retries != null) {
                    this.m_pollingRetries = retries;
                }
            }
            catch (FinderException e) {
                m_log.debug((Object)("run():" + e.getMessage()));
                this.m_message = Messages.getString((String)"message.snmp.6");
                this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
                return false;
            }
            catch (NamingException e) {
                m_log.debug((Object)("run():" + e.getMessage()));
                this.m_message = Messages.getString((String)"message.snmp.6");
                this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
                return false;
            }
            RequestSnmp m_request = new RequestSnmp();
            boolean result = m_request.polling(InetAddress.getByName(ipNetworkNumber), this.m_communityName, this.m_snmpPort, this.m_snmpOid, this.m_snmpVersion, this.m_pollingTimeout, this.m_pollingRetries);
            if (result) {
                this.m_value = m_request.getValue();
                this.m_nodeDate = m_request.getDate();
                this.m_messageOrg = this.m_messageOrg + ", " + Messages.getString((String)"select.value") + " : " + this.m_value;
            } else {
                this.m_message = m_request.getMessage();
            }
            return result;
        }
        catch (UnknownHostException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.snmp.5");
            this.m_messageOrg = this.m_messageOrg + " (" + e.getMessage() + ")";
            return false;
        }
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorSnmpInfoPK pk = new MonitorSnmpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_snmp = MonitorSnmpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_communityName = this.m_snmp.getCommunityName().trim();
        this.m_snmpPort = this.m_snmp.getSnmpPort();
        this.m_snmpOid = this.m_snmp.getSnmpOid().trim();
        this.m_snmpVersion = SnmpVersionConstant.stringToType((String)this.m_snmp.getSnmpVersion().trim());
    }

    public String getMessageId(int id) {
        String messageId = super.getMessageId(id);
        if (messageId == null || "".equals(messageId)) {
            return MESSAGE_ID_UNKNOWN;
        }
        return messageId;
    }

    public String getMessage(int id) {
        String message = super.getMessage(id);
        if (message == null || "".equals(message)) {
            return this.m_message;
        }
        return message;
    }

    public String getMessageOrg(int id) {
        return this.m_messageOrg;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    static {
        m_attributeList.add("ipProtocolNumber");
        m_attributeList.add("ipNetworkNumber");
        m_attributeList.add("ccIpNetworkNumberV6");
        m_attributeList.add("ccSnmpTimeout");
        m_attributeList.add("ccSnmpRetries");
    }
}

