/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.bean;

import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Facility
extends CollectorScopeSnapData
implements Serializable,
Comparable {
    public static final String COMPOSITE = "comp";
    public static final String SCOPE = "scope";
    public static final String NODE = "node";
    private HashSet<Facility> m_parents = null;
    private HashMap<CollectorItemInfo, Double> m_calcTempValues;

    public Facility(String facilityID, String facilityName, String type) {
        this.setFacilityId(facilityID);
        this.setFacilityName(facilityName);
        this.setFacilityType(type);
        this.m_parents = new HashSet();
        this.m_calcTempValues = new HashMap();
    }

    public void addParents(Facility parent) {
        this.getParents().add(parent);
    }

    protected int getNodeCount() {
        return 0;
    }

    public abstract double calcValue(CollectorItemInfo var1);

    public HashSet<Facility> getParents() {
        return this.m_parents;
    }

    public int compareTo(Object o) {
        return this.getFacilityId().compareTo(((Facility)o).getFacilityId());
    }

    public double getCalcValueBuffer(CollectorItemInfo item) {
        Double value = this.m_calcTempValues.get(item);
        if (value == null) {
            return Double.NaN;
        }
        return value;
    }

    public void setCalcValueBuffer(CollectorItemInfo item, double data) {
        this.m_calcTempValues.put(item, new Double(data));
    }
}

