/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.factory;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.ejb.entity.DeviceInfoData;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.DeviceInfoUtil;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeLocal;
import com.clustercontrol.repository.ejb.entity.FacilityTreeUtil;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoLocal;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoUtil;
import com.clustercontrol.repository.util.ListSorter;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFacility {
    public static final String SEPARATOR = ">";

    public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            for (int i = 0; i < attributes.size(); ++i) {
                String attribute = (String)attributes.get(i);
                if (attribute.compareTo("ccFacilityId") == 0) {
                    map.put(attribute, facility.getFacilityId());
                    continue;
                }
                if (attribute.compareTo("cn") == 0) {
                    map.put(attribute, facility.getCn());
                    continue;
                }
                if (attribute.compareTo("description") == 0) {
                    map.put(attribute, facility.getDescription());
                    continue;
                }
                if (attribute.compareTo("ccAgentControl") == 0) {
                    map.put(attribute, facility.getAgentControl());
                    continue;
                }
                if (attribute.compareTo("ccAgentWatch") == 0) {
                    map.put(attribute, facility.getAgentWatch());
                    continue;
                }
                if (attribute.compareTo("ccAgentWatchStatus") == 0) {
                    map.put(attribute, facility.getAgentWatchStatus());
                    continue;
                }
                if (attribute.compareTo("ccCharSet") == 0) {
                    map.put(attribute, facility.getCharSet());
                    continue;
                }
                if (attribute.compareTo("ccCreateTimestamp") == 0) {
                    map.put(attribute, facility.getCreateTimestamp());
                    continue;
                }
                if (attribute.compareTo("ccCreatorsName") == 0) {
                    map.put(attribute, facility.getCreatorsName());
                    continue;
                }
                if (attribute.compareTo("ccDhcpClient") == 0) {
                    map.put(attribute, facility.getDhcpClient());
                    continue;
                }
                if (attribute.compareTo("host") == 0) {
                    map.put(attribute, facility.getHost());
                    continue;
                }
                if (attribute.compareTo("ipNetworkNumber") == 0) {
                    map.put(attribute, facility.getIpNetworkNumber());
                    continue;
                }
                if (attribute.compareTo("ccIpNetworkNumberV6") == 0) {
                    map.put(attribute, facility.getIpNetworkNumberV6());
                    continue;
                }
                if (attribute.compareTo("ipProtocolNumber") == 0) {
                    map.put(attribute, facility.getIpProtocolNumber());
                    continue;
                }
                if (attribute.compareTo("ccIpType") == 0) {
                    map.put(attribute, facility.getIpType());
                    continue;
                }
                if (attribute.compareTo("ccLogWatch") == 0) {
                    map.put(attribute, facility.getLogWatch());
                    continue;
                }
                if (attribute.compareTo("ccMachine") == 0) {
                    map.put(attribute, facility.getMachine());
                    continue;
                }
                if (attribute.compareTo("ccManagerContact") == 0) {
                    map.put(attribute, facility.getManagerContact());
                    continue;
                }
                if (attribute.compareTo("ccManagerName") == 0) {
                    map.put(attribute, facility.getManagerName());
                    continue;
                }
                if (attribute.compareTo("ccModifiersName") == 0) {
                    map.put(attribute, facility.getModifiersName());
                    continue;
                }
                if (attribute.compareTo("ccModifyTimestamp") == 0) {
                    map.put(attribute, facility.getModifyTimestamp());
                    continue;
                }
                if (attribute.compareTo("ccNodeName") == 0) {
                    map.put(attribute, facility.getNodeName());
                    continue;
                }
                if (attribute.compareTo("ccOsName") == 0) {
                    map.put(attribute, facility.getOsName());
                    continue;
                }
                if (attribute.compareTo("ccOsRelease") == 0) {
                    map.put(attribute, facility.getOsRelease());
                    continue;
                }
                if (attribute.compareTo("ccOsVersion") == 0) {
                    map.put(attribute, facility.getOsVersion());
                    continue;
                }
                if (attribute.compareTo("ccPingWatch") == 0) {
                    map.put(attribute, facility.getPingWatch());
                    continue;
                }
                if (attribute.compareTo("ccPingWatchStatus") == 0) {
                    map.put(attribute, facility.getPingWatchStatus());
                    continue;
                }
                if (attribute.compareTo("ccPlatform") == 0) {
                    map.put(attribute, facility.getPlatform());
                    continue;
                }
                if (attribute.compareTo("ccStatusWatch") == 0) {
                    map.put(attribute, facility.getStatusWatch());
                    continue;
                }
                if (attribute.compareTo("ccFacilitySortValue") == 0) {
                    map.put(attribute, facility.getSortValue());
                    continue;
                }
                if (attribute.compareTo("ccSnmpCommunity") == 0) {
                    map.put(attribute, facility.getSnmpCommunity());
                    continue;
                }
                if (attribute.compareTo("ccSnmpPort") == 0) {
                    map.put(attribute, facility.getSnmpPort());
                    continue;
                }
                if (attribute.compareTo("ccSnmpVersion") == 0) {
                    map.put(attribute, facility.getSnmpVersion());
                    continue;
                }
                if (attribute.compareTo("ccValid") == 0) {
                    map.put(attribute, facility.getValid());
                    continue;
                }
                if (attribute.compareTo("ccSnmpTimeout") == 0) {
                    map.put(attribute, facility.getSnmpTimeout());
                    continue;
                }
                if (attribute.compareTo("ccSnmpRetries") == 0) {
                    map.put(attribute, facility.getSnmpRetries());
                    continue;
                }
                if (attribute.compareTo("ccSnmpProxy") == 0) {
                    map.put(attribute, facility.getSnmpProxy());
                    continue;
                }
                if (attribute.compareTo("ccNote") == 0) {
                    map.put(attribute, facility.getNote());
                    continue;
                }
                if (attribute.compareTo("ccIconImage") == 0) {
                    map.put(attribute, facility.getIconImage());
                    continue;
                }
                if (attribute.compareTo("ccVirtualizationNodeType") == 0) {
                    map.put(attribute, facility.getVirtNodeType());
                    continue;
                }
                if (attribute.compareTo("ccVMManagementNode") == 0) {
                    map.put(attribute, facility.getVMManagementNode());
                    continue;
                }
                if (attribute.compareTo("ccVMINDEX") == 0) {
                    map.put(attribute, facility.getVmIndex());
                    continue;
                }
                if (attribute.compareTo("ccVMName") == 0) {
                    map.put(attribute, facility.getVmName());
                    continue;
                }
                if (attribute.compareTo("ccVirtualizationSolution") != 0) continue;
                map.put(attribute, facility.getVirtSolution());
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return map;
    }

    public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
        HashMap<String, HashMap> map = new HashMap<String, HashMap>();
        for (int i = 0; i < facilityIdList.size(); ++i) {
            String facilityId = (String)facilityIdList.get(i);
            HashMap detailMap = this.getNodeDetail(facilityId, attributes);
            map.put(facilityId, detailMap);
        }
        return map;
    }

    public ArrayList<DeviceInfoData> getDeviceList(String facilityId) throws FinderException, NamingException {
        ArrayList<DeviceInfoData> list = null;
        try {
            DeviceInfoData data;
            Collection ct = DeviceInfoUtil.getLocalHome().findByFacilityId(facilityId);
            list = new ArrayList<DeviceInfoData>();
            for (DeviceInfoLocal d : ct) {
                data = new DeviceInfoData(d.getDn(), d.getCn(), d.getFacilityId(), d.getDescription(), d.getDeviceIndex(), d.getDeviceName(), d.getDeviceType(), d.getSnmpOID());
                list.add(data);
            }
            ct = FileSystemInfoUtil.getLocalHome().findByFacilityId(facilityId);
            for (FileSystemInfoLocal f : ct) {
                data = new DeviceInfoData(f.getDn(), f.getCn().toString(), f.getFacilityId(), f.getDescription(), f.getCn(), f.getFileSystemMountPoint(), "filesystem", f.getSnmpOID());
                list.add(data);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeList() throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = FacilityUtil.getLocalHome().findAllNode();
            list = new ArrayList();
            for (FacilityLocal ft : ct) {
                ArrayList<String> info = new ArrayList<String>();
                info.add(ft.getFacilityId());
                info.add(ft.getCn());
                info.add(ft.getDescription());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = null;
            ct = level == 0 ? FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId) : FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId);
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList();
            for (FacilityTreeLocal ft : ct) {
                if (map.get(ft.getFacilityId()) != null) continue;
                map.put(ft.getFacilityId(), "1");
                FacilityLocal facility = ft.getFacility();
                ArrayList<String> info = new ArrayList<String>();
                info.add(facility.getFacilityId());
                info.add(facility.getCn());
                info.add(facility.getDescription());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeList(Property property) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
            String facilityId = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
            String facilityName = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            String description = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV4");
            String ipAddressV4 = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV6");
            String ipAddressV6 = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osName");
            String osName = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"osRelease");
            String osRelease = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"administrator");
            String managerName = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"contact");
            String managerContact = (String)values.get(0);
            Collection ct = FacilityUtil.getLocalHome().findNode(facilityId, facilityName, description, ipAddressV4, ipAddressV6, osName, osRelease, managerName, managerContact);
            list = new ArrayList();
            for (FacilityLocal ft : ct) {
                ArrayList<String> info = new ArrayList<String>();
                info.add(ft.getFacilityId());
                info.add(ft.getCn());
                info.add(ft.getDescription());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = null;
            ct = level == 0 ? FacilityTreeUtil.getLocalHome().findAll(parentFacilityId) : FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList<String>();
            Iterator itr = ct.iterator();
            int i = 0;
            while (itr.hasNext()) {
                FacilityTreeLocal ft;
                if (i == 0) {
                    if (i == 0 && parentFacilityId != null && parentFacilityId.compareTo("") != 0 && map.get(parentFacilityId) == null) {
                        map.put(parentFacilityId, "1");
                        list.add(parentFacilityId);
                    }
                    ++i;
                }
                if (map.get((ft = (FacilityTreeLocal)itr.next()).getFacilityId()) != null) continue;
                map.put(ft.getFacilityId(), "1");
                list.add(ft.getFacilityId());
            }
            if (sort) {
                ListSorter sorter = new ListSorter();
                sorter.sort(list);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort, Boolean valid) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = null;
            ct = level == 0 ? (valid == null ? FacilityTreeUtil.getLocalHome().findAllNode(parentFacilityId) : FacilityTreeUtil.getLocalHome().findAllNodeByValid(parentFacilityId, valid)) : (valid == null ? FacilityTreeUtil.getLocalHome().findOneLevelNode(parentFacilityId) : FacilityTreeUtil.getLocalHome().findOneLevelNodeByValid(parentFacilityId, valid));
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList<String>();
            for (FacilityTreeLocal ft : ct) {
                if (map.get(ft.getFacilityId()) != null) continue;
                map.put(ft.getFacilityId(), "1");
                list.add(ft.getFacilityId());
            }
            if (sort) {
                ListSorter sorter = new ListSorter();
                sorter.sort(list);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = FacilityUtil.getLocalHome().findAllNode();
            list = new ArrayList<String>();
            for (FacilityLocal ft : ct) {
                list.add(ft.getFacilityId());
            }
            if (sort) {
                ListSorter sorter = new ListSorter();
                sorter.sort(list);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel(parentFacilityId);
            list = new ArrayList();
            for (FacilityTreeLocal ft : ct) {
                FacilityLocal facility = ft.getFacility();
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(facility.getFacilityId());
                info.add(facility.getCn());
                info.add(facility.getDescription());
                info.add(ft.getSortValue());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public FacilityLocal getFacility(String facilityId) throws FinderException, NamingException {
        FacilityLocal facility = null;
        try {
            facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return facility;
    }

    public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
            FacilityTreeItem item = this.getFacilityTree(Locale.getDefault());
            list = new ArrayList();
            for (FacilityTreeLocal ft : ct) {
                String[] dn = ft.getDn().split(",");
                StringBuffer path = new StringBuffer();
                for (int i = 1; i < dn.length - 1; ++i) {
                    String id = dn[i].replaceFirst("[\\s\\w]*=", "");
                    FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(id);
                    if (facility.getType() == 0) {
                        path.insert(0, SEPARATOR);
                    }
                    path.insert(0, facility.getCn());
                }
                ArrayList<String> info = new ArrayList<String>();
                info.add(path.toString());
                list.add(info);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public FacilityTreeItem getFacilityTree(Locale locale) throws FinderException, NamingException {
        FacilityInfo info = new FacilityInfo();
        info.setFacilityName("");
        info.setType(2);
        FacilityTreeItem tree = new FacilityTreeItem(null, info);
        info = new FacilityInfo();
        info.setFacilityName(Messages.getString((String)"scope", (Locale)locale));
        info.setType(2);
        FacilityTreeItem item = new FacilityTreeItem(tree, info);
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findOneLevel();
            for (FacilityTreeLocal ft : ct) {
                this.createFacilityTree(ft, item);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return tree;
    }

    public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
        FacilityInfo info = new FacilityInfo();
        info.setFacilityName("");
        info.setType(2);
        FacilityTreeItem tree = new FacilityTreeItem(null, info);
        info = new FacilityInfo();
        info.setFacilityName(Messages.getString((String)"scope", (Locale)locale));
        info.setType(2);
        FacilityTreeItem item = new FacilityTreeItem(tree, info);
        try {
            Collection ct = FacilityTreeUtil.getLocalHome().findOneLevelScope(null);
            for (FacilityTreeLocal ft : ct) {
                this.createScopeFacilityTree(ft, item);
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return tree;
    }

    protected void createFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent) {
        FacilityLocal facility = null;
        try {
            facility = facilityTree.getFacility();
        }
        catch (FinderException e) {
            return;
        }
        FacilityInfo info = null;
        FacilityTreeItem item = null;
        if (facility != null) {
            info = new FacilityInfo();
            info.setFacilityId(facility.getFacilityId());
            info.setFacilityName(facility.getCn());
            if (facility.getType() == 1) {
                info.setType(1);
            } else {
                info.setType(0);
            }
            info.setSortOrder(facilityTree.getSortValue().intValue());
            info.setBuiltInFlg(facilityTree.isBuiltIn());
            info.setValid(facilityTree.getValid().booleanValue());
            item = new FacilityTreeItem(parent, info);
        }
        Collection collection = null;
        try {
            collection = facilityTree.getChildren();
        }
        catch (FinderException e) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            for (FacilityTreeLocal children : collection) {
                this.createFacilityTree(children, item);
            }
        }
    }

    protected void createScopeFacilityTree(FacilityTreeLocal facilityTree, FacilityTreeItem parent) {
        FacilityLocal facility = null;
        try {
            facility = facilityTree.getFacility();
        }
        catch (FinderException e) {
            return;
        }
        FacilityInfo info = null;
        FacilityTreeItem item = null;
        if (facility != null) {
            info = new FacilityInfo();
            info.setFacilityId(facility.getFacilityId());
            info.setFacilityName(facility.getCn());
            info.setSortOrder(facilityTree.getSortValue().intValue());
            if (facility.getType() == 0) {
                info.setType(0);
                item = new FacilityTreeItem(parent, info);
            } else {
                return;
            }
        }
        Collection collection = null;
        try {
            collection = facilityTree.getChildren();
        }
        catch (FinderException e) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            for (FacilityTreeLocal children : collection) {
                this.createScopeFacilityTree(children, item);
            }
        }
    }

    public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
        block12: {
            try {
                Collection ct = FacilityTreeUtil.getLocalHome().findByFacilityId(facilityId);
                if (ct == null) break block12;
                FacilityTreeLocal tree = null;
                Iterator itr = ct.iterator();
                if (itr.hasNext()) {
                    tree = (FacilityTreeLocal)itr.next();
                }
                if (tree == null) break block12;
                StringBuffer buffer = new StringBuffer();
                if (tree.getTreeType() == 0) {
                    if (parentFacilityId != null && parentFacilityId.length() > 0) {
                        for (FacilityTreeLocal parentTree = tree; parentTree != null; parentTree = parentTree.getParent()) {
                            FacilityLocal parent = parentTree.getFacility();
                            if (parentFacilityId.compareTo(parent.getFacilityId()) == 0) {
                                if (buffer.length() == 0) {
                                    buffer.insert(0, SEPARATOR);
                                }
                                break;
                            }
                            buffer.insert(0, SEPARATOR);
                            buffer.insert(0, parent.getCn());
                        }
                    } else {
                        for (FacilityTreeLocal parentTree = tree; parentTree != null; parentTree = parentTree.getParent()) {
                            FacilityLocal parent = parentTree.getFacility();
                            buffer.insert(0, SEPARATOR);
                            buffer.insert(0, parent.getCn());
                        }
                    }
                } else {
                    FacilityLocal facility = tree.getFacility();
                    buffer.append(facility.getCn());
                }
                return buffer.toString();
            }
            catch (FinderException e) {
                throw e;
            }
            catch (NamingException e) {
                throw e;
            }
        }
        return "";
    }

    public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct;
            HashMap<String, String> map = new HashMap<String, String>();
            list = new ArrayList<String>();
            if (ipAddress != null && ipAddress.length() > 0) {
                ct = FacilityUtil.getLocalHome().findByIpAddress(ipAddress);
                for (FacilityLocal facility : ct) {
                    if (map.get(facility.getFacilityId()) != null) continue;
                    map.put(facility.getFacilityId(), "1");
                    list.add(facility.getFacilityId());
                }
            }
            if (hostName != null && hostName.length() > 0) {
                ct = FacilityUtil.getLocalHome().findByNodeName(hostName);
                for (FacilityLocal facility : ct) {
                    if (map.get(facility.getFacilityId()) != null) continue;
                    map.put(facility.getFacilityId(), "1");
                    list.add(facility.getFacilityId());
                }
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return list;
    }

    public boolean isNode(String facilityId) throws FinderException, NamingException {
        boolean node = false;
        try {
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            if (facility.getType() == 1) {
                node = true;
            }
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return node;
    }
}

