/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent.util;

import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingContextFactory;

public class LoginManager {
    private static LoginManager m_instance = null;
    private NamingContext m_namingcontext = null;
    private LoginContext m_loginContext = null;
    private Properties m_props = null;
    private String m_uid = null;
    private String m_password = null;

    public static LoginManager getContextManager(Properties prop) {
        if (m_instance == null) {
            m_instance = new LoginManager(prop);
        }
        return m_instance;
    }

    private LoginManager(Properties prop) {
        this.m_props = prop;
        try {
            Configuration.setConfiguration(new HinemosClientConfig());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void login(String uid, String password) throws Exception {
        this.logout();
        this.m_uid = uid;
        this.m_password = password;
        this.m_namingcontext = this.getContext();
        RepositoryControllerHome home = (RepositoryControllerHome)this.m_namingcontext.lookup("RepositoryController");
        try {
            home.create();
        }
        catch (Exception e) {
            this.logout();
            throw e;
        }
    }

    public synchronized void logout() throws NamingException {
        if (this.m_loginContext instanceof LoginContext) {
            try {
                this.m_loginContext.logout();
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        this.m_loginContext = null;
        this.m_namingcontext = null;
    }

    public boolean isLogin() {
        return this.m_loginContext instanceof LoginContext;
    }

    public synchronized NamingContext getNamingContext() throws NamingException {
        if (!this.isLogin()) {
            String uid = this.m_props.getProperty("user.name");
            String password = this.m_props.getProperty("user.password");
            try {
                this.login(uid, password);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_namingcontext;
    }

    private NamingContext getContext() throws NamingException, LoginException {
        UsernamePasswordHandler handler = new UsernamePasswordHandler(this.m_uid, this.m_password.toCharArray());
        this.m_loginContext = new LoginContext("hinemosClient", (CallbackHandler)handler);
        this.m_loginContext.login();
        NamingContextFactory ncf = new NamingContextFactory();
        NamingContext namingContext = (NamingContext)ncf.getInitialContext((Hashtable)this.m_props);
        return namingContext;
    }

    class HinemosClientConfig
    extends Configuration {
        HinemosClientConfig() {
        }

        public void refresh() {
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            AppConfigurationEntry[] entry = null;
            try {
                Class[] parameterTypes = new Class[]{};
                Method m = this.getClass().getDeclaredMethod(name, parameterTypes);
                Object[] args = new Object[]{};
                entry = (AppConfigurationEntry[])m.invoke((Object)this, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return entry;
        }

        AppConfigurationEntry[] hinemosClient() {
            String name = "org.jboss.security.ClientLoginModule";
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("multi-threaded", "true");
            options.put("restore-login-identity", "true");
            AppConfigurationEntry ace = new AppConfigurationEntry(name, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
            AppConfigurationEntry[] entry = new AppConfigurationEntry[]{ace};
            return entry;
        }
    }
}

