/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.ReceiveTopic;
import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.agent.UpdateRepositoryInfoReceiveTopic;
import com.clustercontrol.agent.util.EjbConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Agent {
    private Properties m_props;
    private EjbConnectionManager m_ejbConnectionManager;
    private ReceiveTopic m_receiveTopic;
    private SendQueue m_sendQueue;
    private UpdateRepositoryInfoReceiveTopic m_updateRepository;
    protected Timer m_timer = new Timer(true);
    private long m_cacheInterval = 600000L;
    private static Log log = LogFactory.getLog(Agent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        log.info((Object)"starting Hinemos job agent...");
        log.info((Object)("java.vm.version = " + System.getProperty("java.vm.version")));
        log.info((Object)("java.vm.vendor = " + System.getProperty("java.vm.vendor")));
        log.info((Object)("java.home = " + System.getProperty("java.home")));
        log.info((Object)("os.name = " + System.getProperty("os.name")));
        log.info((Object)("os.arch = " + System.getProperty("os.arch")));
        log.info((Object)("user.name = " + System.getProperty("user.name")));
        log.info((Object)("user.dir = " + System.getProperty("user.dir")));
        Agent agent = new Agent(args[0]);
        agent.exec();
        log.info((Object)"Hinemos job agent started");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                String line = br.readLine();
                if (line.equals("quit")) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Agent agent2 = agent;
            synchronized (agent2) {
                agent.wait();
            }
        }
        agent.terminate();
    }

    public Agent(String propFileName) throws Exception {
        this.m_props = new Properties();
        try {
            this.m_props.load(new FileInputStream(propFileName));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        String casheInterval = this.m_props.getProperty("facility.update.interval");
        if (casheInterval != null) {
            try {
                this.m_cacheInterval = Long.parseLong(casheInterval);
            }
            catch (NumberFormatException e) {
                log.error((Object)"facility.update.interval", (Throwable)e);
            }
        }
        this.m_ejbConnectionManager = new EjbConnectionManager(this.m_props);
        this.m_sendQueue = new SendQueue(this, this.m_props);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Agent.this.terminate();
            }
        });
    }

    public void exec() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u30c8\u30d4\u30c3\u30af\u63a5\u7d9a");
        }
        this.m_receiveTopic = new ReceiveTopic(this, this.getFacility(), this.m_sendQueue, this.m_props);
        this.m_updateRepository = new UpdateRepositoryInfoReceiveTopic(this, this.m_props);
        this.m_timer.schedule((TimerTask)new ReflashFilterTask(), this.m_cacheInterval, this.m_cacheInterval);
    }

    public Collection getFacility() {
        HashMap<String, String> map;
        block13: {
            map = new HashMap<String, String>();
            RepositoryController repository = null;
            try {
                repository = this.m_ejbConnectionManager.getRepositoryController();
            }
            catch (Exception e1) {
                return map.values();
            }
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                if (null == networkInterfaces) break block13;
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface ni = networkInterfaces.nextElement();
                    if (log.isDebugEnabled()) {
                        try {
                            log.debug((Object)("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u691c\u51fa:\t" + new String(ni.getDisplayName().getBytes("iso-8859-1"))));
                        }
                        catch (UnsupportedEncodingException e) {
                            log.debug((Object)"\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u691c\u51fa:\t", (Throwable)e);
                        }
                    }
                    Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress in4 = inetAddresses.nextElement();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("IP/HOST\u691c\u51fa:\t" + in4.getHostAddress() + "/" + in4.getHostName()));
                        }
                        if (in4.getHostAddress().compareTo("127.0.0.1") == 0) continue;
                        ArrayList facilityIdList = repository.getFacilityIdList(in4.getHostName(), in4.getHostAddress());
                        if (log.isDebugEnabled() && facilityIdList.size() == 0) {
                            log.debug((Object)"\u5bfe\u5fdc\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u306a\u3057");
                        }
                        for (String facilityId : facilityIdList) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\u5bfe\u5fdc\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3:" + facilityId));
                            }
                            if (map.containsKey(facilityId)) continue;
                            map.put(facilityId, facilityId);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)"\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u60c5\u5831\u53d6\u5f97\u5931\u6557");
                log.error((Object)e);
            }
        }
        return map.values();
    }

    public void terminate() {
        this.m_receiveTopic.terminate();
        this.m_updateRepository.terminate();
        this.m_sendQueue.terminate();
        this.m_timer.cancel();
        log.info((Object)"Hinemos job agent stopped");
    }

    public void setFacility() {
        this.m_receiveTopic.setFacilityIdList(this.getFacility());
    }

    public synchronized void reConnection() {
        log.info((Object)"Hinemos job agent reconnect start");
        this.m_receiveTopic.reconnect();
        this.m_updateRepository.reconnect();
        this.m_sendQueue.reconnect();
        log.info((Object)"Hinemos job agent reconnect end");
    }

    protected class ReflashFilterTask
    extends TimerTask {
        protected ReflashFilterTask() {
        }

        public void run() {
            Agent.this.setFacility();
        }
    }
}

