/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import javassist.CtConstructor;
import javassist.NotFoundException;
import org.jboss.aop.metadata.MethodConfig;
import org.jboss.aop.util.XmlHelper;
import org.w3c.dom.Element;

public class ConstructorConfig {
    String signature = null;

    public boolean patternMatches(Constructor constructor) {
        if (this.signature.equals("*")) {
            return true;
        }
        String sig = MethodConfig.getSignature(constructor.getParameterTypes());
        return sig.equals(this.signature);
    }

    public boolean patternMatches(CtConstructor constructor) throws NotFoundException {
        if (this.signature.equals("*")) {
            return true;
        }
        String sig = MethodConfig.getSignature(constructor.getParameterTypes());
        return sig.equals(this.signature);
    }

    public void importXml(Element element) throws Exception {
        Element paramsElement = XmlHelper.getOptionalChild(element, "constructor-params");
        if (paramsElement == null) {
            String content = XmlHelper.getElementContent(element);
            if (content == null || !content.equals("*")) {
                throw new RuntimeException("Empty <constructor> element must have at least an empty <constructor-params> element");
            }
            this.signature = "*";
            return;
        }
        this.signature = "(";
        Iterator paramsIterator = XmlHelper.getChildrenByTagName(paramsElement, "constructor-param");
        while (paramsIterator.hasNext()) {
            this.signature = this.signature + XmlHelper.getElementContent((Element)paramsIterator.next()).trim();
            this.signature = this.signature + " ";
        }
        this.signature = this.signature + ")";
    }
}

