/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.ejb.mdb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ReceiveUpdateRepositoryBeanUtil {
    private static Queue cachedQueue = null;
    private static QueueConnectionFactory cachedConnectionFactory = null;
    private static final String DESTINATION_JNDI_NAME = "topic/clustercontrolRepositoryUpdate";
    private static final String CONNECTION_FACTORY_JNDI_NAME = "";
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue getQueue() throws NamingException {
        if (cachedQueue == null) {
            InitialContext initialContext = new InitialContext();
            try {
                Object objRef = initialContext.lookup(DESTINATION_JNDI_NAME);
                cachedQueue = (Queue)objRef;
            }
            finally {
                initialContext.close();
            }
        }
        return cachedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue getQueue(Hashtable environment) throws NamingException {
        InitialContext initialContext = new InitialContext(environment);
        try {
            Object objRef = initialContext.lookup(DESTINATION_JNDI_NAME);
            Queue queue = (Queue)objRef;
            return queue;
        }
        finally {
            initialContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueueConnection getQueueConnection() throws NamingException, JMSException {
        if (cachedConnectionFactory == null) {
            InitialContext initialContext = new InitialContext();
            try {
                Object objRef = initialContext.lookup(CONNECTION_FACTORY_JNDI_NAME);
                cachedConnectionFactory = (QueueConnectionFactory)objRef;
            }
            finally {
                initialContext.close();
            }
        }
        return cachedConnectionFactory.createQueueConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueueConnection getQueueConnection(Hashtable environment) throws NamingException, JMSException {
        InitialContext initialContext = new InitialContext(environment);
        try {
            Object objRef = initialContext.lookup(CONNECTION_FACTORY_JNDI_NAME);
            QueueConnection queueConnection = ((QueueConnectionFactory)objRef).createQueueConnection();
            return queueConnection;
        }
        finally {
            initialContext.close();
        }
    }

    public static final String generateGUID(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("ReceiveUpdateRepositoryBeanUtil: Could not get the local IP address using InetAddress.getLocalHost()!");
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = ReceiveUpdateRepositoryBeanUtil.hexFormat(ReceiveUpdateRepositoryBeanUtil.getInt(serverIP), 8);
        }
        String hashcode = ReceiveUpdateRepositoryBeanUtil.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(ReceiveUpdateRepositoryBeanUtil.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(ReceiveUpdateRepositoryBeanUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return ReceiveUpdateRepositoryBeanUtil.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

