/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.bean.NotifyTypeConstant;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyJobInfo;
import com.clustercontrol.notify.bean.NotifyLogEscalateInfo;
import com.clustercontrol.notify.bean.NotifyMailInfo;
import com.clustercontrol.notify.bean.NotifyStatusInfo;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyJobInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyMailInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyStatusInfoLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectNotify {
    protected static Log m_log = LogFactory.getLog(SelectNotify.class);

    public NotifyInfo getNotify(String notifyId) throws FinderException, NamingException {
        NotifyInfoLocal notify = NotifyInfoUtil.getLocalHome().findByPrimaryKey(notifyId);
        return this.getNotify(notify);
    }

    public NotifyInfo getNotify(NotifyInfoLocal notify) throws FinderException, NamingException {
        NotifyInfo bean = null;
        String notifyId = notify.getNotifyId();
        ArrayList notifyEvents = this.getNotifyDetails(notifyId, notify);
        bean = new NotifyInfo(notify.getNotifyId(), notify.getDescription(), notify.getNotifyType(), notify.getInhibitionFlg(), notify.getInhibitionFrequency(), notify.getInhibitionPeriod(), notify.getRegDate(), notify.getUpdateDate(), notify.getRegUser(), notify.getUpdateUser(), notify.getValidFlg(), notifyEvents);
        return bean;
    }

    public ArrayList getNotifyDetails(String notifyId, NotifyInfoLocal notify) {
        ArrayList<Object> notifyEvents = new ArrayList<Object>();
        try {
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            if (notify.getNotifyType() == 0) {
                Collection ct = notify.getNotifyStatusInfo();
                Iterator itr = ct.iterator();
                NotifyStatusInfoLocal local = null;
                while (itr.hasNext()) {
                    local = (NotifyStatusInfoLocal)itr.next();
                    NotifyStatusInfo status = new NotifyStatusInfo(notifyId, local.getPriority(), local.getStatusFlg(), local.getStatusInhibitionFlg(), local.getStatusInvalidFlg(), local.getStatusUpdatePriority(), local.getStatusValidPeriod());
                    notifyEvents.add(status);
                }
            } else if (notify.getNotifyType() == 1) {
                Collection ct = notify.getNotifyEventInfo();
                Iterator itr = ct.iterator();
                NotifyEventInfoLocal local = null;
                while (itr.hasNext()) {
                    local = (NotifyEventInfoLocal)itr.next();
                    NotifyEventInfo event = new NotifyEventInfo(notifyId, local.getPriority(), local.getEventNormalFlg(), local.getEventNormalState(), local.getEventInhibitionFlg(), local.getEventInhibitionState());
                    notifyEvents.add(event);
                }
            } else if (notify.getNotifyType() == 2) {
                Collection ct = notify.getNotifyMailInfo();
                Iterator itr = ct.iterator();
                NotifyMailInfoLocal local = null;
                while (itr.hasNext()) {
                    local = (NotifyMailInfoLocal)itr.next();
                    NotifyMailInfo status = new NotifyMailInfo(notifyId, local.getPriority(), local.getMailTemplateId(), local.getMailFlg(), local.getMailInhibitionFlg(), local.getMailAddress());
                    notifyEvents.add(status);
                }
            } else if (notify.getNotifyType() == 3) {
                Collection ct = notify.getNotifyJobInfo();
                Iterator itr = ct.iterator();
                NotifyJobInfoLocal local = null;
                while (itr.hasNext()) {
                    local = (NotifyJobInfoLocal)itr.next();
                    String facilityPath = repository.getFacilityPath(local.getJobExecFacility(), null);
                    NotifyJobInfo status = new NotifyJobInfo(notifyId, local.getPriority(), local.getJobRun(), local.getJobId(), local.getJobInhibitionFlg(), local.getJobFailurePriority(), local.getJobExecFacilityFlg(), local.getJobExecFacility(), facilityPath);
                    notifyEvents.add(status);
                }
            } else if (notify.getNotifyType() == 4) {
                Collection ct = notify.getNotifyLogEscalateInfo();
                Iterator itr = ct.iterator();
                NotifyLogEscalateInfoLocal local = null;
                while (itr.hasNext()) {
                    local = (NotifyLogEscalateInfoLocal)itr.next();
                    String facilityPath = repository.getFacilityPath(local.getEscalateFacility(), null);
                    NotifyLogEscalateInfo status = new NotifyLogEscalateInfo(notifyId, local.getPriority(), local.getEscalateFlg(), local.getEscalateInhibitionFlg(), local.getEscalateMessage(), local.getSyslogPriority(), local.getSyslogFacility(), local.getEscalateFacilityFlg(), local.getEscalateFacility(), facilityPath, local.getEscalatePort());
                    notifyEvents.add(status);
                }
            }
        }
        catch (NamingException e) {
            m_log.error((Object)("getNotifyDetails() : " + e.getMessage()), (Throwable)e);
        }
        catch (FinderException e) {
            m_log.error((Object)("getNotifyDetails() : " + e.getMessage()), (Throwable)e);
        }
        catch (CreateException e) {
            m_log.error((Object)("getNotifyDetails() : " + e.getMessage()), (Throwable)e);
        }
        return notifyEvents;
    }

    public ArrayList getNotifyIdList() throws FinderException, NamingException {
        ArrayList<String> list = null;
        try {
            Collection ct = NotifyInfoUtil.getLocalHome().findAllOrderByNotifyId();
            Iterator itr = ct.iterator();
            while (itr.hasNext()) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                NotifyInfoLocal notify = (NotifyInfoLocal)itr.next();
                list.add(notify.getNotifyId());
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "005");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "005");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public ArrayList getNotifyList() throws CreateException, FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = NotifyInfoUtil.getLocalHome().findAllOrderByNotifyId();
            list = this.collectionToArray(ct);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public HashMap<String, NotifyInfo> getNotifyMap() throws FinderException, NamingException {
        HashMap<String, NotifyInfo> map = new HashMap<String, NotifyInfo>();
        try {
            Collection ct = NotifyInfoUtil.getLocalHome().findAll();
            Iterator itr = ct.iterator();
            NotifyInfo bean = null;
            NotifyInfoLocal notify = null;
            while (itr.hasNext()) {
                notify = (NotifyInfoLocal)itr.next();
                bean = this.getNotify(notify);
                map.put(notify.getNotifyId(), bean);
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyMap():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            apllog.put("SYS", "006");
            m_log.debug((Object)("getNotifyMap():" + e.getMessage()));
            throw e;
        }
        return map;
    }

    private ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException {
        ArrayList list = new ArrayList();
        for (NotifyInfoLocal notify : ct) {
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(false);
            info.add(notify.getValidFlg());
            info.add(notify.getNotifyId());
            info.add(notify.getDescription());
            info.add(NotifyTypeConstant.typeToString((int)notify.getNotifyType()));
            info.add(notify.getUpdateDate() == null ? null : new Date(notify.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }
}

