#!/bin/sh

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details
 

#ユーザチェック
if [ !  `whoami` = root ]; then
    echo "Please execute by a root user."
    exit
fi

#設定情報読み込み
. ${0%/*}/install.cfg


SYSLOGNG_FLG=0

##
## syslog-ngのアンインストール
##
syslogng_uninstall() {
	while [ 1 ] ;
	do
		echo ""
		echo "Uninstall syslog-ng ?  (Y/N)"
		read ANS_SYS
		case ${ANS_SYS} in
			y|Y)
  				#syslog-ngアンインストール
				/etc/init.d/syslog-ng stop
				/etc/init.d/syslog start
    			/sbin/chkconfig --level 2345 syslog-ng off
				/sbin/chkconfig --level 2345 syslog on
				rpm -e syslog-ng libol
				echo "Syslog-ng was uninstalled."
				echo ""
				echo "The backup file of syslog-ng.conf was created."
				echo "	/etc/syslog-ng/syslog-ng.conf.rpmsave"	
				echo "Please confirm it after completing the uninstallation."
				break
				;;
			n|N)
				echo "Syslog-ng was not uninstalled."
				echo "Please refer to the installation manual when you change the setting."
				break
				;;
			*)
				;;
		esac
	done
}


##
## hinemosユーザの削除
##
user_uninstall() {
	while [ 1 ] ;
	do
		echo ""
		echo "User ${HINEMOS_USER} is deleted. (The home directory of user ${HINEMOS_USER} is deleted. )"
		echo "Is it all right (Y/N)?"
		read ANS_USER
		case ${ANS_USER} in
 			y|Y)
 				id ${HINEMOS_USER} > /dev/null 2>&1
 				if [ "${?}" = "0" ] ; then
					userdel -r ${HINEMOS_USER}
					echo "User ${HINEMOS_USER} was deleted."
				else
					echo "User ${HINEMOS_USER} doesn't exist."
				fi
				break
				;;
			n|N)
				echo "User ${HINEMOS_USER} was not deleted."
				break
				;;
 			*)
				;;
		esac
	done
}

##
## アンインストーラ本編
##
while [ 1 ] ;
do
	echo "Hinemos will be uninstalled. Is it all right (Y/N)?"
	read ANS
	case ${ANS} in
		y|Y)
	  		#プロセス終了確認
  	  		ps axu | grep postgres | grep -v grep | grep hinemos > /dev/null
	  		RET1=$?  

	  		ps axu | grep slapd | grep -v grep | grep hinemos > /dev/null 
	  		RET2=$?  

	  		ps axu | grep run_hinemos.sh | grep -v grep | grep hinemos |grep java > /dev/null 
	  		RET3=$? 

	  		if [ ${RET1} -eq 0 -o ${RET2} -eq 0 -o ${RET3} -eq 0 ]; then
				echo "Hinemos is running. Please execute uninstallation after stopping Hinemos."
				echo "The uninstallation is canceled."
				exit 1
	  		fi

			# syslog-ngのアンインストール
			rpm -q syslog-ng > /dev/null
			if [ "${?}" = "0" ] ; then
				syslogng_uninstall
			fi

			# hinemosユーザの削除
			user_uninstall
		
			#Hinemosマネージャファイルの削除
			echo ""
			echo "${HINEMOS_HOME} is deleted."
			if [ -d ${HINEMOS_HOME} ] ; then
				rm -fr ${HINEMOS_HOME}
				echo "${HINEMOS_HOME} was deleted."
			else
				echo "${HINEMOS_HOME} doesn't exist."
			fi

			#残存する設定の表示
			echo ""
			echo "The following settings are not changed because there is a possibility that the settings are used by any programs but hinemos."
			echo "	・Setting of /etc/hosts file"
			echo "	・Setting of kernel memory (SHMMAX,SHMALL)"
			echo "Please refer to the installation manual for details."

			sleep 2

			echo ""
			echo "Uninstallation was completed."
			break
	  		;;
		*)
	  		echo "The uninstallation was canceled."
			break
	  		;;
	esac
done
