#!/bin/sh

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み
export EXEC_PATH=${0%/*}

. ${EXEC_PATH}/install.cfg

EXEC_USER=`/usr/bin/whoami`

# check for incorrect user
if [ $EXEC_USER != "root" ]; then
	echo "Please execute by a root user."
	exit
fi


##
## カーネルリソースの確認
##
kernel_resurce_check(){
	# SHMMAXの確認
	if [ "${CURRENT_SHMMAX}" -lt "${SHMMAX}" ] ;then
		echo "Current SHMMAX size is "\
		`echo ${CURRENT_SHMMAX}`"."
		while [ 1 ] ;
		do
			echo " May I change SHMMAX size into ${SHMMAX} (512MB) ? (Y/N default:Y)"
			read ANS
			ANS=${ANS:-Y}
			
			case ${ANS} in
				y|Y)
					echo ${SHMMAX} > /proc/sys/kernel/shmmax
					echo "" >> /etc/sysctl.conf
					echo "#add for Hinemos Manager" >> /etc/sysctl.conf
					echo "kernel.shmmax=${SHMMAX}" >> /etc/sysctl.conf
					break
					;;
				n|N)
					echo "The installation is canceled."
					exit 1
					;;
				*)
					echo ""
					;;
			esac
		done	
	fi
	
	# SHMALLの変更
	if [ "${CURRENT_SHMALL}" -lt "${SHMALL}" ] ;then
		echo " Current SHMALL size is "\
		`echo ${CURRENT_SHMALL}`"."
		while [ 1 ] ;
		do
			echo "May I change SHMALL size into ${SHMALL} (512MB) ? (Y/N default:Y)"
			read ANS
			ANS=${ANS:-Y}
			
			case ${ANS} in
				y|Y)
					echo ${SHMALL} > /proc/sys/kernel/shmall
					echo "" >> /etc/sysctl.conf
					echo "#add for Hinemos Manager" >> /etc/sysctl.conf
					echo "kernel.shmall=${SHMALL}" >> /etc/sysctl.conf
					break
					;;
				n|N)
					echo "The installation is canceled."
					exit 1
					;;
				*)
					echo ""
					;;
			esac
		done
	fi
}

##
## hinemosユーザの確認
##
make_user() {
	echo "User ${HINEMOS_USER} is created."
	TMP=0
	id ${HINEMOS_USER} > /dev/null 2>&1 && TMP=1
	
	#${HINEMOS_USER}が存在する場合
	if [ "$TMP" -eq "1" ] ; then
		echo "User ${HINEMOS_USER} already exists."	
	else
		/usr/sbin/useradd ${HINEMOS_USER}
		/usr/bin/passwd ${HINEMOS_USER}
		echo "User ${HINEMOS_USER} was created."
	fi
	sleep 2
}

##
## インストールディレクトリの確認
##
make_installdir() {
	echo "Installation directory ${HINEMOS_HOME} is created."
	if [ -d ${HINEMOS_HOME} ] ; then
		echo "Warning: Installation directory ${HINEMOS_HOME} already exists."
		echo "Please change the directory name or delete it."
		echo ""
		echo "The installation is canceled."
		sleep 2
		exit 1
	else
		mkdir -p ${HINEMOS_HOME}
		chown -R ${HINEMOS_USER}:${HINEMOS_USER} ${HINEMOS_HOME}
		echo "Installation directory ${HINEMOS_HOME} was created."
	fi
}

##
## 一括制御スクリプトの設定
##
crun_setting() {
	#ftpサーバのIPアドレスを一括制御スクリプトに挿入
	echo "Please input ftp server's IP address needed by corrective run (default:127.0.0.1)"
	read FTP_SERVER
	FTP_SERVER=${FTP_SERVER:-"127.0.0.1"}
	sed "s/%%hinemos_ftp_host%%/${FTP_SERVER}/"  ${EXEC_PATH}/hinemos/lib/cr/cp.sh > ${HINEMOS_HOME}/lib/cr/cp.sh
	sed "s/%%hinemos_ftp_host%%/${FTP_SERVER}/"  ${EXEC_PATH}/hinemos/lib/cr/rpminstall.sh > ${HINEMOS_HOME}/lib/cr/rpminstall.sh
	
	#JREのバージョンを一括制御スクリプトに挿入
	sed "s/%%jre_version%%/${JRE_NAME}/"  ${EXEC_PATH}/hinemos/lib/cr/agent_install.sh > ${HINEMOS_HOME}/lib/cr/tmp_agent_install.sh
	
	#Hinemosのバージョンを一括制御スクリプトに挿入
	HINEMOS_VERSION=`cat ${EXEC_PATH}/hinemos/_version`
	sed "s/%%hinemos_version%%/${HINEMOS_VERSION}/"  ${HINEMOS_HOME}/lib/cr/tmp_agent_install.sh > ${HINEMOS_HOME}/lib/cr/agent_install.sh
	rm ${HINEMOS_HOME}/lib/cr/tmp_agent_install.sh
}

##
## syslog-ngの設定
##
syslogng_install() {
	HINEMOS_VERSION=`cat ${HINEMOS_HOME}/_version`
	#syslog-ngインストール
	echo "Start the installation of syslog-ng."
	echo ""
	
	#インストールチェック
	TMP=0
	rpm -q syslog-ng > /dev/null
	
	if [ "${?}" -eq "1" ] ; then
		chmod 766 /dev/log
		
		# rpmインストール
		rpm -ivh --force ${SYSLOG_NG_RPM}
		
		# syslog-ng.conf の編集
		sed -e "s%__HINEMOS_HOME__%${HINEMOS_HOME}%g" -e "s%__JRE__%${JRE_NAME}%g" -e "s%__VERSION__%${HINEMOS_VERSION}%g" ./syslog-ng_setup.conf >> /etc/syslog-ng/syslog-ng.conf
		
		echo "Syslog-ng was installed."
		
		# syslogの停止、syslog-ng の起動
		echo "Syslog is stopped, and syslog-ng is started."
		/etc/init.d/syslog stop
		/etc/init.d/syslog-ng start
		/sbin/chkconfig --level 2345 syslog off
		/sbin/chkconfig --level 2345 syslog-ng on
	else
		echo "Warning: Syslog-ng has already been installed."
		echo "Please change the setting. (Please refer to the installation manual.)"
		sleep 2
	fi
}

##
## /etc/hostsの確認
##
hosts_check() {

	#/etc/hostsの設定
	HOSTS_FILE=/etc/hosts
	HOST=`hostname`
	
	while [ 1 ] ;
	do
		echo ""
		echo "${HOSTS_FILE} is changed."
		echo "May I change ${HOSTS_FILE}? (Y/N)"
		read ANS
		echo ""
		case ${ANS} in
			y|Y)
				#IPアドレスの取得
				while [ 1 ] ;
				do
					echo "Please input IP address of the server which installed Hinemos manager."
					read IPADDRESS
					echo "Is it ${IPADDRESS}? (Y/N default:Y)"
					read IP_ANS
					IP_ANS=${IP_ANS:-Y}
					echo ""
					case ${IP_ANS} in
						y|Y)
							break
							;;
						n|N)
							;;
						*)
							echo "Please input Y or N."
							;;
					esac
				done
				
				#hostsファイルのバックアップを取る
				#バックアップ用時刻を取得
				DATE=`date +%m%d%H%M`
				cp -pr ${HOSTS_FILE} ${HOSTS_FILE}.bk_${DATE}
				_FLAG=0
				
				#hostsファイルにホスト名とlocalhostの記述が一行に存在するか確認する
				#ただし、ホスト名とlocalhostの間に「#」が含まれる場合は、検出しない
				TMP_HOST=`cat ${HOSTS_FILE} | grep "${HOST}[^\#]*localhost\|localhost[^\#]*${HOST}" | grep -v "^\s*\#"`
				
				#TMP_HOSTが空でない場合
				if [ "${TMP_HOST}" != "" ] ; then
					TMP_INSERT=`echo ${TMP_HOST} | sed "s/\s${HOST}\s/\t/g"`
					sed "s/${TMP_HOST}/#${TMP_HOST}\n${TMP_INSERT}/g" ${HOSTS_FILE} > ${HOSTS_FILE}_tmp
					mv -f ${HOSTS_FILE}_tmp ${HOSTS_FILE}
					_FLAG=1
				fi
				
				#hostsファイルに、ホスト名に対するIPアドレスが振られていない場合
				if [ "`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#"`" = "" ]; then
					echo "${IPADDRESS}      ${HOST}" >> ${HOSTS_FILE}
					_FLAG=1
				fi
				
				#ホスト名とIPアドレス対応の最終確認
				#ホスト名に対し、入力されたIPアドレス以外のアドレスが登録されていた場合
				if [ "${IPADDRESS}" != "`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#" | awk '{print $1}'`" ]; then
					echo "Warning：IP address set as the host name ${HOST} in ${HOSTS_FILE} is different from input IP address."
					echo "Please change the setting according to the installation manual."
					mv -f ${HOSTS_FILE}.bk_${DATE} ${HOSTS_FILE}
					break
				fi
				
				if [ "${_FLAG}" != "0" ]; then
					echo "${HOSTS_FILE} was changed."
					echo "Please confirm it after the end of the installation."
				else
					echo "${HOSTS_FILE} needs not to be changed."
				fi
				rm -f ${HOSTS_FILE}.bk_${DATE}
				
				break
				;;
			n|N)
				echo "${HOSTS_FILE} was not changed."
				echo "Please change the setting according to the installation manual."
				sleep 1
				break
				;;
			*)
				echo "Please input Y or N."
				;;
		esac
	done
}




##
## インストール本編(始)
##
echo ""
echo "Hinemos installation will be started, is that OK？(Y/N default:Y)"
while [ 1 ] ;
do
	read ANS
	ANS=${ANS:-Y}
	case ${ANS} in
		y|Y)
			echo ""
			echo "The installation user and the installation directory are created. "
			echo ""
			
			# インストールユーザの作成
			make_user
			echo ""
			
			# インストールディレクトリの作成
			make_installdir			
			echo ""
			
			# /opt/hinemos以下にコピー
			echo "Start copying required files into the installation directory."
			cp -pr ${EXEC_PATH}/hinemos /opt
			
			#インストールディレクトリに応じて各設定ファイルを変更
			REPLACE_PATH=`echo ${HINEMOS_HOME} | sed 's/\//\\\\\//g'`
			sed -e "s/%%hinemos_install_dir%%/${REPLACE_PATH}/" -e "s/%%jre_name%%/${JRE_NAME}/" ${EXEC_PATH}/hinemos.cfg > ${HINEMOS_HOME}/hinemos.cfg
			
			
			# 一括制御の設定
			crun_setting
			
			echo "Copying required files was completed."
			echo ""
			
			
			# JREのインストール
			echo "Installing JRE"
			sleep 2
			echo ""
			cp ${EXEC_PATH}/${JRE_VERSION}-linux-i586.bin ${HINEMOS_HOME}
			CURRENT_DIR=`pwd`
			cd ${HINEMOS_HOME}
			${HINEMOS_HOME}/${JRE_VERSION}-linux-i586.bin
			rm ${HINEMOS_HOME}/${JRE_VERSION}-linux-i586.bin
			cd ${CURRENT_DIR}
			
			
			# ${HINEMOS_HOME}のオーナーをhinemosユーザに変更する
			chown -R ${HINEMOS_USER}:${HINEMOS_USER} ${HINEMOS_HOME}
			
			# fpingのオーナーはrootユーザである必要があるため変更する
			chown root:root ${HINEMOS_HOME}/sbin/fping
			chmod 4755 ${HINEMOS_HOME}/sbin/fping
			
			# syslog-ngの設定
			syslogng_install
			
			# /etc/hostsの確認
			hosts_check
			
			echo ""
			sleep 1
			
			
			# DB初期化
			echo "The database is initialized."
			
			# カーネルリソースの確認
			kernel_resurce_check
			
			cd ${HINEMOS_HOME}
			su -c ${HINEMOS_HOME}/sbin/db_init/pg_init.sh ${HINEMOS_USER}
			
			
			# LDAP初期化
			echo ""
			echo "LDAP is initialized."
			
			cd ${HINEMOS_HOME}
			su -c ${HINEMOS_HOME}/sbin/db_init/ldap_init.sh ${HINEMOS_USER}
			
			REVAL=$?
			if [ "${REVAL}" -eq 0 ]; then
				echo "The initialization of LDAP was completed."
				echo ""
			fi
			
			
			echo "Hinemos manager installation was completed."
			echo ""
			break
			;;
		n|N)
			echo "Hinemos installation is ended."
			exit 0
			;;
		*)
			;;
	esac
done		
##
## インストーラ本編(終)
##
