#!/bin/sh

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details
 

#ユーザチェック
if [ !  `whoami` = root ]; then
    echo "Please execute by a root user."
    exit
fi

#設定情報読み込み
. ${0%/*}/install.cfg

echo "Hinemos will be uninstalled. Is it all right (Y/N)?"
read ANS
case ${ANS} in
	y|Y)
	  #プロセス終了
  	  ps axu | grep postgres | grep -v grep | grep hinemos > /dev/null
	  RET1=$?  

	  ps axu | grep slapd | grep -v grep | grep hinemos > /dev/null 
	  RET2=$?  

	  ps axu | grep run.sh | grep -v grep | grep hinemos |grep java > /dev/null 
	  RET3=$? 

	  if [ $RET1 -eq 0 -o $RET2 -eq 0 -o $RET3 -eq 0 ]; then
		echo "Hinemos is running. Please execute uninstallation after stopping Hinemos."
	  else

		echo "uninstall syslog-ng ?  (Y/N)"
	        read ANS_SYS
       		case ${ANS_SYS} in
                y|Y)
                #syslog-ngアンインストール
                        echo "uninstalling syslog-ng. "
                        /etc/init.d/syslog-ng stop
                        /etc/init.d/syslog start
                        /sbin/chkconfig --level 2345 syslog-ng off
                        /sbin/chkconfig --level 2345 syslog on
                        rpm -e syslog-ng libol
                ;;
                *)
                ;;
       		 esac
		
		echo "Can you delete user "hinemos" ?  (Y/N)"
	        read USER
        	case ${USER} in
        	 y|Y)
                userdel hinemos
                	echo "User hinemos is deleted."
                ;;
         	*)
                ;;
        	esac
	
        echo "Can you remove /home/hinemos ?(Y/N)"
        read HOME_DIR
        case ${HOME_DIR} in
         y|Y)
                rm -fr /home/hinemos
                echo "/home/hinemos is deleted."
                ;;
        *)
                ;;
        esac




		#Hinemosマネージャファイルの削除
		echo "Hinemos Manager Files is deleted."
		rm -fr /opt/hinemos
		echo "Uninstallation was completed."
	  fi
	  ;;
	*)
	  echo "Uninstallation of Hinemos was stopped."
	  ;;
esac
