/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.ejb.bmp;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.bean.EventCode;
import com.clustercontrol.performanceMGR.bean.OIDInfo;
import com.clustercontrol.performanceMGR.bean.QuartzConstant;
import com.clustercontrol.performanceMGR.bean.ScopeTree;
import com.clustercontrol.performanceMGR.dao.CalculatedDataDAO;
import com.clustercontrol.performanceMGR.dao.CollectorItemDAO;
import com.clustercontrol.performanceMGR.dao.DeviceDAO;
import com.clustercontrol.performanceMGR.dao.RecordDataDAO;
import com.clustercontrol.performanceMGR.dao.ScopeRelationDAO;
import com.clustercontrol.performanceMGR.dao.ScopeSnapDAO;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorPK;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusLocal;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusPK;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorStatusUtil;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performanceMGR.job.CollectJob;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoHome;
import com.clustercontrol.performanceMGR.monitor.factory.RunMonitorPerformance2;
import com.clustercontrol.performanceMGR.util.CalculationMethod;
import com.clustercontrol.performanceMGR.util.FacilityTreeDB;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.snmppoller.bean.PollingConfig;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class CollectorBean
implements EntityBean {
    protected static Log m_log = LogFactory.getLog(CollectorBean.class);
    private final int MAX_LIFECOUNT = 2;
    private int lifetimeCounter;
    private int collectorType;
    private String collectorID = null;
    private int interval;
    private String facilityID;
    private ScopeTree scopeTree;
    private CollectorItemInfo[] items;
    private String label;
    private long startTime;
    private long stopTime;
    private String scopePath;
    private int period;
    private int presavePeriod;
    private OIDInfo[] targetOID;
    protected EntityContext entityCtx;

    public CollectorPK ejbCreate(RecordCollectorData data, List itemList) throws CreateException {
        m_log.debug((Object)("ejbCreate() start : " + data.getCollectorID()));
        this.items = itemList.toArray(new CollectorItemInfo[itemList.size()]);
        this.setCollectorID(data.getCollectorID());
        this.setCollectorType(data.getCollectorType());
        this.setFacilityID(data.getFacilityID());
        this.setInterval(data.getInterval());
        this.setLabel(data.getLabel());
        this.setPeriod(data.getPeriod());
        this.setScopePath(data.getScopePath());
        this.setPresavePeriod(data.getPresavePeriod());
        m_log.debug((Object)("ejbCreate() e : " + data.getCollectorID()));
        return new CollectorPK(data.getCollectorID());
    }

    public void ejbPostCreate(RecordCollectorData data, List itemList) throws CreateException {
        m_log.debug((Object)("ejbPostCreate()  Collector Type : " + this.collectorType));
        Repository repository = new Repository();
        FacilityTreeItem facilityTree = repository.getFacilityTree(this.facilityID);
        this.scopeTree = new ScopeTree(facilityTree);
        this.setScopePath(repository.getFacilityPath(this.facilityID));
        if (this.collectorType == 2) {
            new FacilityTreeDB().insertFacilityTree(this.collectorID, facilityTree);
            List<DeviceData> deviceList = repository.getDeviceList(this.facilityID);
            DeviceDAO dvdao = new DeviceDAO();
            Iterator<DeviceData> itr = deviceList.iterator();
            while (itr.hasNext()) {
                dvdao.insertDeviceData(this.collectorID, itr.next());
            }
        }
        CollectorItemDAO cidao = new CollectorItemDAO();
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].setCollectorID(this.collectorID);
            cidao.registCollectorItem(this.items[i]);
        }
        try {
            CollectorStatusUtil.getLocalHome().create(new CollectorStatusPK(this.collectorID));
        }
        catch (NamingException e) {
            m_log.error((Object)e);
            throw new EJBException((Exception)e);
        }
    }

    public void setCollectorItems(String collectoId) {
        CollectorItemDAO cidao = new CollectorItemDAO();
        Collection col = cidao.selectCollectorItemByCollectorID(collectoId);
        this.items = col.toArray(new CollectorItemInfo[col.size()]);
        this.targetOID = CalculationMethod.getTargetOid(this.items);
    }

    public CollectorPK ejbFindByPrimaryKey(CollectorPK pk) throws FinderException {
        return pk;
    }

    public Collection ejbFindByCollectorType(int type) throws FinderException {
        m_log.debug((Object)("ejbFindByStatus() : Type = " + type));
        return null;
    }

    public Collection ejbFindByPresave() throws FinderException {
        m_log.debug((Object)"ejbFindByPresave() : ");
        return null;
    }

    public Collection ejbFindByCollectorTypeAndFacilityId(int type, String facilityId) throws FinderException {
        m_log.debug((Object)("ejbFindByCollectorTypeAndFacilityId() : Type = " + type + ", FacilityID = " + facilityId));
        return null;
    }

    public Collection ejbFindAll() throws FinderException {
        m_log.debug((Object)"ejbFindAll() : ");
        return null;
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbLoad() throws EJBException, RemoteException {
        m_log.debug((Object)("ejbLoad() start : " + this.collectorID));
        m_log.debug((Object)("ejbLoad() end   : " + this.collectorID));
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws RemoveException, EJBException, RemoteException {
        m_log.debug((Object)("ejbRemove() start : " + this.collectorID));
        this.deleteJob();
        try {
            CollectorStatusUtil.getLocalHome().remove(new CollectorStatusPK(this.collectorID));
        }
        catch (NamingException e) {
            m_log.error((Object)e);
            throw new EJBException((Exception)e);
        }
        CollectorItemDAO cidao = new CollectorItemDAO();
        cidao.deleteCollectorItemByCollectorID(this.collectorID);
        DeviceDAO dvdao = new DeviceDAO();
        dvdao.deleteDeviceDataByCollectorID(this.collectorID);
        ScopeRelationDAO srdao = new ScopeRelationDAO();
        ScopeSnapDAO ssdao = new ScopeSnapDAO();
        srdao.deleteScopeRelationByCollectorID(this.collectorID);
        ssdao.deleteScopeSnapByCollectorID(this.collectorID);
        RecordDataDAO dataDao = new RecordDataDAO();
        dataDao.deleteRecordData(this.collectorID);
        CalculatedDataDAO calDao = new CalculatedDataDAO();
        calDao.delete(this.collectorID);
        m_log.debug((Object)("ejbRemove() end   : " + this.collectorID));
    }

    public void ejbStore() throws EJBException, RemoteException {
    }

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.entityCtx = ctx;
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
    }

    public RecordCollectorData getRecordColletorData() {
        m_log.debug((Object)"getRecordColletorData() strat : ");
        RecordCollectorData data = new RecordCollectorData();
        data.setCollectorID(this.getCollectorID());
        data.setCollectorType(this.getCollectorType());
        data.setFacilityID(this.getFacilityID());
        data.setInterval(this.getInterval());
        data.setCount(this.getCount());
        data.setLabel(this.getLabel());
        data.setStatus(this.getStatus());
        data.setPeriod(this.getPeriod());
        data.setScopePath(this.getScopePath());
        data.setStartDate(this.getStartDate());
        data.setStopDate(this.getStopDate());
        data.setFacilityTree(this.getFacilityTree());
        data.setRealCollectPeriod(this.getRealCollectPeriod());
        data.setEndStatus(this.getEndStatus());
        data.setPresavePeriod(this.getPresavePeriod());
        m_log.debug((Object)"getRecordColletorData() end   : ");
        return data;
    }

    public void startCollect() throws NamingException {
        m_log.debug((Object)("startCollect() start : " + this.collectorID + " " + this.collectorType));
        this.setCollectorType(this.collectorType);
        this.startPoller();
        this.targetOID = CalculationMethod.getTargetOid(this.items);
        this.stopTime = this.period == -1 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(this.period * 60) * 1000L;
        this.scheduleJob();
        this.setStartDate(new Date(System.currentTimeMillis()));
        this.scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
        m_log.debug((Object)("startCollect() end   : " + this.collectorID + " " + this.collectorType));
    }

    public boolean restartCollect() throws NamingException {
        m_log.debug((Object)("restartCollect() start : " + this.collectorID + " " + this.collectorType + " to " + this.stopTime));
        boolean isRunning = false;
        if (this.getStatus() == 100) {
            isRunning = true;
        }
        boolean isRestart = false;
        this.startPoller();
        this.targetOID = CalculationMethod.getTargetOid(this.items);
        this.scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
        this.scheduleJob();
        isRestart = true;
        if (this.collectorType == 2) {
            String[] messages = new String[]{"CollectorID : " + this.collectorID};
            this.outputLog(EventCode.WarningRestart, messages);
        } else if (this.collectorType == 3) {
            // empty if block
        }
        if (!isRunning) {
            this.setErrorStatus(1);
        }
        m_log.debug((Object)("restartCollect() end   : " + this.collectorID + " " + this.collectorType + " to " + this.stopTime));
        return isRestart;
    }

    private void startPoller() throws NamingException {
        if (this.scopeTree == null || this.facilityID == null) {
            return;
        }
        String[] nodeIDList = this.scopeTree.getNodeIDList(this.facilityID);
        SnmpSharedTable sst = null;
        InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
        Object obj = iniCtx.lookup("SnmpPerf");
        sst = (SnmpSharedTable)PortableRemoteObject.narrow((Object)obj, SnmpSharedTable.class);
        if (this.collectorType != 1) {
            m_log.debug((Object)"polling start . wait time 1000ms");
            sst.setPollingSchedule(nodeIDList, this.interval, 1000L);
        } else {
            m_log.debug((Object)"polling start . wait time 0ms");
            sst.setPollingSchedule(nodeIDList, this.interval, 0L);
        }
    }

    public CollectedDataInfo getValue(String facilityId, String itemCode, int deviceIndex, String deviceName) {
        this.resetLifetimeCounter();
        CollectedDataInfo data = this.scopeTree.getValue(facilityId, itemCode, deviceIndex, deviceName);
        if (this.collectorType == 1 && Double.isNaN(data.getValue())) {
            data = this.scopeTree.getTempValue(facilityId, itemCode, deviceIndex, deviceName);
        }
        return data;
    }

    public CollectedDataInfo getValue(String facilityId, int itemId) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].getCollectorItemID() != itemId) continue;
            return this.getValue(facilityId, this.items[i].getCollectorItemCode(), this.items[i].getDeviceIndex(), this.items[i].getDeviceName());
        }
        return null;
    }

    public CollectedDataInfo[] getValueAll(String facilityId) {
        CollectedDataInfo[] dataList = new CollectedDataInfo[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            dataList[i] = this.getValue(facilityId, this.items[i].getCollectorItemCode(), this.items[i].getDeviceIndex(), this.items[i].getDeviceName());
        }
        return dataList;
    }

    public List getSubScopeValues(String facilityId, String itemCode, int deviceIndex, String deviceName) {
        ArrayList<CollectedDataInfo> ret = new ArrayList<CollectedDataInfo>();
        String[] subScopeFids = this.scopeTree.getSubScopeIDList(facilityId);
        for (int i = 0; i < subScopeFids.length; ++i) {
            ret.add(this.getValue(subScopeFids[i], itemCode, deviceIndex, deviceName));
        }
        return ret;
    }

    public List getSubScopeValues(String facilityId, int itemId) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].getCollectorItemID() != itemId) continue;
            return this.getSubScopeValues(facilityId, this.items[i].getCollectorItemCode(), this.items[i].getDeviceIndex(), this.items[i].getDeviceName());
        }
        return null;
    }

    public void stopCollect() {
        m_log.debug((Object)("stopCollect() start : " + this.collectorID));
        this.deleteJob();
        this.setStopDate(new Date(System.currentTimeMillis()));
        m_log.debug((Object)("stopCollect() end   : " + this.collectorID));
    }

    private void scheduleJob() throws NamingException {
        m_log.debug((Object)("scheduleJob()  Group : PERF_COLLECT : " + this.collectorID + " : " + this.interval));
        JobDetail job = new JobDetail(this.collectorID, "PERF_COLLECT", CollectJob.class);
        job.setDurability(true);
        job.getJobDataMap().put((Object)"pk", (Object)new CollectorPK(this.collectorID));
        job.getJobDataMap().put("type", this.collectorType);
        CronTrigger cronTrigger = new CronTrigger(this.collectorID, "PERF_COLLECT");
        cronTrigger.setMisfireInstruction(2);
        try {
            int delayTimeOver1min;
            String cronString = PollingConfig.parseCronExpression((int)this.interval);
            cronString = "0 */10 * * * ? *";
            if (this.interval < 60) {
                int delayTimeUnder1min = QuartzConstant.getDelayTimeUnder1min();
                cronString = delayTimeUnder1min + "/" + this.interval + " * * * * ? *";
            } else if (60 <= this.interval && this.interval < 3600) {
                delayTimeOver1min = QuartzConstant.getDelayTimeOver1min();
                cronString = delayTimeOver1min + " */" + this.interval / 60 + " * * * ? *";
            } else if (3600 <= this.interval) {
                delayTimeOver1min = QuartzConstant.getDelayTimeOver1min();
                cronString = delayTimeOver1min + " 0 */" + this.interval / 3600 + " * * ? *";
            } else {
                String message = "\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u306a\u3044\u53ce\u96c6\u9593\u9694\u3067\u3059";
                throw new EJBException(message);
            }
            cronTrigger.setCronExpression(cronString);
            cronTrigger.setEndTime(new Date(this.stopTime));
        }
        catch (ParseException e) {
            m_log.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            m_log.error((Object)e);
            return;
        }
        InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
        Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
        try {
            scheduler.deleteJob(this.collectorID, "PERF_COLLECT");
            scheduler.scheduleJob(job, (Trigger)cronTrigger);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e);
        }
    }

    private void pauseJob() {
        m_log.debug((Object)("pauseJob() start : " + this.collectorID));
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
            scheduler.pauseJob(this.collectorID, "PERF_COLLECT");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e);
        }
        m_log.debug((Object)("pauseJob() end   : " + this.collectorID));
    }

    private void resumeJob() {
        m_log.debug((Object)("pauseJob() start : " + this.collectorID));
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
            scheduler.resumeJob(this.collectorID, "PERF_COLLECT");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e);
        }
        m_log.debug((Object)("pauseJob() end   : " + this.collectorID));
    }

    private void deleteJob() {
        m_log.debug((Object)("deleteJob() start : " + this.collectorID));
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
            scheduler.deleteJob(this.collectorID, "PERF_COLLECT");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (SchedulerException e) {
            m_log.error((Object)e);
        }
        m_log.debug((Object)("deleteJob() end   : " + this.collectorID));
    }

    public void fetchMibValue() {
        m_log.debug((Object)("fetchMibValue() start : " + this.collectorID + "  " + this.collectorType));
        try {
            if (this.scopeTree == null || this.targetOID == null) {
                m_log.debug((Object)"lost facility tree info.");
            } else {
                this.scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
            }
            this.setLastCollectDate(new Date(System.currentTimeMillis()));
            this.setCollectCount(this.getCount() + 1);
            ++this.lifetimeCounter;
        }
        catch (Exception e) {
            m_log.error((Object)e);
            this.setErrorStatus(2);
        }
        m_log.debug((Object)("fetchMibValue() end   : " + this.collectorID + "  " + this.collectorType));
    }

    public void storeCalcValue() {
        m_log.debug((Object)("storeCalcValue() start : " + this.collectorID + "  " + this.collectorType));
        try {
            if (this.scopeTree == null || this.items == null || this.targetOID == null) {
                m_log.debug((Object)"\u60c5\u5831\u3092\u5931\u3063\u3066\u3044\u307e\u3059");
            } else {
                this.scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
                String[] fids = this.scopeTree.getAllFacilityIdList();
                for (int i = 0; i < this.items.length; ++i) {
                    for (int j = 0; j < fids.length; ++j) {
                        CollectedDataInfo data = this.getValue(fids[j], this.items[i].getCollectorItemCode(), this.items[i].getDeviceIndex(), this.items[i].getDeviceName());
                        CalculatedDataDAO dao = new CalculatedDataDAO();
                        dao.insert(this.collectorID, data);
                    }
                }
                this.setLastCollectDate(new Date(this.scopeTree.getLastCollectTime()));
                this.setCollectCount(this.getCount() + 1);
            }
        }
        catch (Exception e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            this.setErrorStatus(2);
        }
        m_log.debug((Object)("storeCalcValue() end   : " + this.collectorID + "  " + this.collectorType));
    }

    public void monitorCalcValue() {
        m_log.debug((Object)("monitorCalcValue() start : " + this.collectorID + "  " + this.collectorType));
        if (this.scopeTree == null || this.items == null || this.targetOID == null) {
            m_log.debug((Object)"\u60c5\u5831\u3092\u5931\u3063\u3066\u3044\u307e\u3059");
            return;
        }
        try {
            this.scopeTree.fetchMibValue(this.facilityID, this.targetOID, this.interval);
            MonitorPerfInfoHome home = JNDIConnectionManager.getMonitorPerfInfo();
            Collection mPerfInfos = home.findAll();
            for (MonitorPerfInfo monInfoLocal : mPerfInfos) {
                if (!monInfoLocal.getCollectorId().equals(this.collectorID)) continue;
                String monitorTypeId = monInfoLocal.getMonitorTypeId();
                String monitorId = monInfoLocal.getMonitorId();
                String itemCode = monInfoLocal.getItemCode();
                int deviceIndex = monInfoLocal.getDeviceIndex();
                String deviceName = monInfoLocal.getDeviceName();
                CollectedDataInfo data = this.getValue(this.facilityID, itemCode, deviceIndex, deviceName);
                RunMonitorPerformance2 runMonitor = new RunMonitorPerformance2();
                runMonitor.run(monitorTypeId, monitorId, data);
                Repository rep = new Repository();
                if (rep.isNode(this.facilityID)) continue;
                String[] nodeFids = this.scopeTree.getNodeIDList(this.facilityID);
                for (int j = 0; j < nodeFids.length; ++j) {
                    data = this.getValue(nodeFids[j], itemCode, deviceIndex, deviceName);
                    runMonitor = new RunMonitorPerformance2();
                    runMonitor.run(monitorTypeId, monitorId, data);
                }
            }
            this.setLastCollectDate(new Date(this.scopeTree.getLastCollectTime()));
            this.setCollectCount(this.getCount() + 1);
        }
        catch (Exception e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        m_log.debug((Object)("monitorCalcValue() end   : " + this.collectorID + "  " + this.collectorType));
    }

    private void resetLifetimeCounter() {
        this.lifetimeCounter = 0;
    }

    public String getCollectorID() {
        return this.collectorID;
    }

    public void setCollectorID(String collectorID) {
        this.collectorID = collectorID;
    }

    public int getCollectorType() {
        return this.collectorType;
    }

    public void setCollectorType(int collectorType) {
        this.collectorType = collectorType;
    }

    public String getFacilityID() {
        return this.facilityID;
    }

    public void setFacilityID(String facilityID) {
        m_log.debug((Object)("setFacilityID() start : " + this.collectorID));
        this.facilityID = facilityID;
        m_log.debug((Object)("setFacilityID() end   : " + this.collectorID));
    }

    public void updateScopeTree() {
        m_log.debug((Object)("updateScopeTree() start : " + this.collectorID));
        FacilityTreeItem tree = this.getFacilityTree();
        if (tree != null) {
            this.scopeTree = new ScopeTree(tree);
        }
        m_log.debug((Object)("updateScopeTree() end   : " + this.collectorID));
    }

    public FacilityTreeItem getFacilityTree() {
        m_log.debug((Object)("getFacilityTree() collector type : " + this.collectorType));
        if (this.facilityID != null && (this.collectorType == 1 || this.collectorType == 3)) {
            return new Repository().getFacilityTree(this.facilityID);
        }
        if (this.collectorID != null && this.collectorType == 2) {
            return new FacilityTreeDB().getFacilityTree(this.collectorID);
        }
        return null;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getCount() {
        return this.getCollectorStatus().getCount();
    }

    public void setCollectCount(int count) {
        this.getCollectorStatus().setCount(count);
    }

    public void setErrorStatus(int status) {
        this.getCollectorStatus().setErrorStatus(status);
        int endStatus = this.getCollectorStatus().getEndStatus();
        if (endStatus == 0 && (status == 1 || status == 2)) {
            this.getCollectorStatus().setEndStatus(status);
        }
        if (endStatus == 1 && status == 2) {
            this.getCollectorStatus().setEndStatus(status);
        }
        if (endStatus != 2 && status == 2) {
            this.getCollectorStatus().setEndStatus(status);
        }
    }

    public String getScopePath() {
        return this.scopePath;
    }

    public void setScopePath(String scopePath) {
        this.scopePath = scopePath;
    }

    public Date getStartDate() {
        if (this.startTime != 0L) {
            return new Date(this.startTime);
        }
        return null;
    }

    public void setStartDate(Date startDate) {
        this.startTime = startDate != null ? startDate.getTime() : 0L;
    }

    public int getStatus() {
        try {
            JobDetail job;
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Scheduler scheduler = (Scheduler)iniCtx.lookup(QuartzConstant.QUARTZ_NAME);
            try {
                job = scheduler.getJobDetail(this.collectorID, "PERF_COLLECT");
            }
            catch (SchedulerException e) {
                m_log.error((Object)e);
                return 400;
            }
            Trigger trigger = null;
            try {
                trigger = scheduler.getTrigger(this.collectorID, "PERF_COLLECT");
            }
            catch (SchedulerException e) {
                m_log.error((Object)e);
                return 400;
            }
            if (trigger == null) {
                if (this.getStartDate() == null) {
                    return 0;
                }
                return 300;
            }
            if (job.isDurable()) {
                return 100;
            }
            return 200;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public Date getStopDate() {
        if (this.stopTime == 0L || this.stopTime == Long.MAX_VALUE) {
            return null;
        }
        return new Date(this.stopTime);
    }

    public void setStopDate(Date stopDate) {
        this.stopTime = stopDate != null ? stopDate.getTime() : Long.MAX_VALUE;
    }

    public long getRealCollectPeriod() {
        Date lastCollect = this.getCollectorStatus().getLastCollectDate();
        if (lastCollect == null) {
            return 0L;
        }
        return lastCollect.getTime() - this.startTime;
    }

    private CollectorStatusLocal getCollectorStatus() {
        try {
            return CollectorStatusUtil.getLocalHome().findByPrimaryKey(new CollectorStatusPK(this.collectorID));
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public int getEndStatus() {
        return this.getCollectorStatus().getEndStatus();
    }

    private void setLastCollectDate(Date date) {
        this.getCollectorStatus().setLastCollectDate(date);
    }

    public boolean checkLifetime() {
        return 2 >= this.lifetimeCounter;
    }

    private void outputLog(String index, String[] messages) {
        AplLogger apllog = new AplLogger("PERF", "perf");
        apllog.put("SYS", index, (Object[])messages);
    }

    public boolean isMonitorFlag() {
        return false;
    }

    public int getPresavePeriod() {
        return this.presavePeriod;
    }

    public void setPresavePeriod(int presavePeriod) {
        this.presavePeriod = presavePeriod;
    }

    public void managePresave(Date startDate) {
        CalculatedDataDAO dao = new CalculatedDataDAO();
        dao.deleteOverPresave(this.collectorID, startDate);
        int count = dao.recountFromDB(this.collectorID);
        if (count > -1) {
            this.setCollectCount(count);
        }
    }
}

