/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import net.sf.cglib.reflect.FastClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;
import org.hibernate.util.ReflectHelper;

public class PojoInstantiator
implements Instantiator,
Serializable {
    private static final Log log = LogFactory.getLog((Class)PojoInstantiator.class);
    private transient Constructor constructor;
    private final Class mappedClass;
    private final transient FastClass fastClass;
    private final boolean embeddedIdentifier;
    private final Class proxyInterface;

    public PojoInstantiator(Component component, FastClass fastClass) {
        this.mappedClass = component.getComponentClass();
        this.fastClass = fastClass;
        this.proxyInterface = null;
        this.embeddedIdentifier = false;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            log.info((Object)("no default (no-argument) constructor for class: " + this.mappedClass.getName() + " (class must be instantiated by Interceptor)"));
            this.constructor = null;
        }
    }

    public PojoInstantiator(PersistentClass persistentClass, FastClass fastClass) {
        this.mappedClass = persistentClass.getMappedClass();
        this.proxyInterface = persistentClass.getProxyInterface();
        this.embeddedIdentifier = persistentClass.hasEmbeddedIdentifier();
        this.fastClass = fastClass;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            log.info((Object)("no default (no-argument) constructor for class: " + this.mappedClass.getName() + " (class must be instantiated by Interceptor)"));
            this.constructor = null;
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
    }

    public Object instantiate() {
        if (ReflectHelper.isAbstractClass(this.mappedClass)) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.mappedClass);
        }
        if (this.fastClass != null) {
            try {
                return this.fastClass.newInstance();
            }
            catch (Throwable t) {
                throw new InstantiationException("Could not instantiate entity with CGLIB: ", this.mappedClass, t);
            }
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.mappedClass);
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, e);
        }
    }

    public Object instantiate(Serializable id) {
        boolean useEmbeddedIdentifierInstanceAsEntity = this.embeddedIdentifier && id != null && id.getClass().equals(this.mappedClass);
        return useEmbeddedIdentifierInstanceAsEntity ? id : this.instantiate();
    }

    public boolean isInstance(Object object) {
        return this.mappedClass.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

