/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.type.Type;

public class FilterImpl
implements Filter,
Serializable {
    public static final String MARKER = "$FILTER_PLACEHOLDER$";
    private transient FilterDefinition definition;
    private String filterName;
    private Map parameters = new HashMap();

    void afterDeserialize(SessionFactoryImpl factory) {
        this.definition = factory.getFilterDefinition(this.filterName);
    }

    public FilterImpl(FilterDefinition configuration) {
        this.definition = configuration;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public Map getParameterTypes() {
        return this.definition.getParameterTypes();
    }

    public Filter setParameter(String name, Object value) throws IllegalArgumentException {
        Type type = this.definition.getParameterType(name);
        if (type == null) {
            throw new IllegalArgumentException("Undefined filter parameter [" + name + "]");
        }
        if (value != null && !type.getReturnedClass().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type for parameter [" + name + "]");
        }
        this.parameters.put(name, value);
        return this;
    }

    public Filter setParameterList(String name, Collection values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("Collection must be not null!");
        }
        Type type = this.definition.getParameterType(name);
        if (type == null) {
            throw new IllegalArgumentException("Undefined filter parameter [" + name + "]");
        }
        if (values != null && values.size() > 0) {
            Class<?> elementClass = values.iterator().next().getClass();
            if (!type.getReturnedClass().isAssignableFrom(elementClass)) {
                throw new IllegalArgumentException("Incorrect type for parameter [" + name + "]");
            }
        }
        this.parameters.put(name, values);
        return this;
    }

    public Filter setParameterList(String name, Object[] values) throws IllegalArgumentException {
        return this.setParameterList(name, Arrays.asList(values));
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public String getName() {
        return this.definition.getFilterName();
    }

    public void validate() throws HibernateException {
        Iterator itr = this.definition.getParameterNames().iterator();
        while (itr.hasNext()) {
            String parameterName = (String)itr.next();
            if (this.parameters.get(parameterName) != null) continue;
            throw new IllegalArgumentException("Filter [" + this.getName() + "] defined parameter [" + parameterName + "] whose value was not set");
        }
    }
}

