/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.PositionSubstringFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.id.SequenceGenerator;

public class PostgreSQLDialect
extends Dialect {
    public PostgreSQLDialect() {
        this.registerColumnType(-7, "bool");
        this.registerColumnType(-5, "int8");
        this.registerColumnType(5, "int2");
        this.registerColumnType(-6, "int2");
        this.registerColumnType(4, "int4");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float4");
        this.registerColumnType(8, "float8");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "bytea");
        this.registerColumnType(2005, "text");
        this.registerColumnType(2004, "oid");
        this.registerColumnType(2, "numeric($p, $s)");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("cbrt", new StandardSQLFunction("cbrt", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction("radians", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", Hibernate.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction("stddev", Hibernate.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction("variance", Hibernate.DOUBLE));
        this.registerFunction("random", new NoArgSQLFunction("random", Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("chr", new StandardSQLFunction("chr", Hibernate.CHARACTER));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("substr", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("initcap", new StandardSQLFunction("initcap"));
        this.registerFunction("to_ascii", new StandardSQLFunction("to_ascii"));
        this.registerFunction("quote_ident", new StandardSQLFunction("quote_ident", Hibernate.STRING));
        this.registerFunction("quote_literal", new StandardSQLFunction("quote_literal", Hibernate.STRING));
        this.registerFunction("md5", new StandardSQLFunction("md5"));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.INTEGER));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.LONG));
        this.registerFunction("char_length", new StandardSQLFunction("char_length", Hibernate.LONG));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", Hibernate.LONG));
        this.registerFunction("octet_length", new StandardSQLFunction("octet_length", Hibernate.LONG));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", Hibernate.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", Hibernate.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("localtime", new NoArgSQLFunction("localtime", Hibernate.TIME, false));
        this.registerFunction("localtimestamp", new NoArgSQLFunction("localtimestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("now", new NoArgSQLFunction("now", Hibernate.TIMESTAMP));
        this.registerFunction("timeofday", new NoArgSQLFunction("timeofday", Hibernate.STRING));
        this.registerFunction("age", new StandardSQLFunction("age"));
        this.registerFunction("current_user", new NoArgSQLFunction("current_user", Hibernate.STRING, false));
        this.registerFunction("session_user", new NoArgSQLFunction("session_user", Hibernate.STRING, false));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING, false));
        this.registerFunction("current_database", new NoArgSQLFunction("current_database", Hibernate.STRING, true));
        this.registerFunction("current_schema", new NoArgSQLFunction("current_schema", Hibernate.STRING, true));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", Hibernate.STRING));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", Hibernate.DATE));
        this.registerFunction("to_timestamp", new StandardSQLFunction("to_timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("to_number", new StandardSQLFunction("to_number", Hibernate.BIG_DECIMAL));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
        this.registerFunction("locate", new PositionSubstringFunction());
        this.registerFunction("str", new SQLFunctionTemplate(Hibernate.STRING, "cast(?1 as varchar)"));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName);
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return "nextval ('" + sequenceName + "')";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getQuerySequencesString() {
        return "select relname from pg_class where relkind='S'";
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(sql).append(hasOffset ? " limit ? offset ?" : " limit ?").toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getIdentitySelectString(String table, String column, int type) {
        return "select currval('" + table + '_' + column + "_seq')";
    }

    public String getIdentityColumnString(int type) {
        return type == -5 ? "bigserial not null" : "serial not null";
    }

    public boolean hasDataTypeInIdentityColumn() {
        return false;
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public Class getNativeIdentifierGeneratorClass() {
        return SequenceGenerator.class;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String getSelectClauseNullString(int sqlType) {
        String typeName = this.getTypeName(sqlType, 1, 1, 0);
        int loc = typeName.indexOf(40);
        if (loc > -1) {
            typeName = typeName.substring(0, loc);
        }
        return "null::" + typeName;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getTemporaryTableCreationCommand() {
        return "create local temporary table";
    }

    public String getTemporaryTableCreationPostfix() {
        return "on commit drop";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "true" : "false";
    }
}

