/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.jdbc.JDBCContext;

public class ThreadLocalSessionContext
implements CurrentSessionContext {
    private static final Log log = LogFactory.getLog((Class)ThreadLocalSessionContext.class);
    private static final Class[] SESS_PROXY_INTERFACES = new Class[]{org.hibernate.classic.Session.class, SessionImplementor.class, JDBCContext.Context.class, EventSource.class};
    private static final ThreadLocal context = new ThreadLocal();
    protected final SessionFactoryImplementor factory;

    public ThreadLocalSessionContext(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    public final org.hibernate.classic.Session currentSession() throws HibernateException {
        org.hibernate.classic.Session current = ThreadLocalSessionContext.existingSession(this.factory);
        if (current == null) {
            current = this.buildOrObtainSession();
            current.getTransaction().registerSynchronization(this.buildCleanupSynch());
            if (this.needsWrapping(current)) {
                current = this.wrap(current);
            }
            ThreadLocalSessionContext.doBind(current, this.factory);
        }
        return current;
    }

    private boolean needsWrapping(org.hibernate.classic.Session session) {
        return !session.getTransaction().isActive();
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected org.hibernate.classic.Session buildOrObtainSession() {
        return this.factory.openSession(null, this.isAutoFlushEnabled(), this.isAutoCloseEnabled(), this.getConnectionReleaseMode());
    }

    protected CleanupSynch buildCleanupSynch() {
        return new CleanupSynch(this.factory);
    }

    protected boolean isAutoCloseEnabled() {
        return true;
    }

    protected boolean isAutoFlushEnabled() {
        return true;
    }

    protected ConnectionReleaseMode getConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_TRANSACTION;
    }

    protected org.hibernate.classic.Session wrap(org.hibernate.classic.Session session) {
        return (org.hibernate.classic.Session)Proxy.newProxyInstance(org.hibernate.classic.Session.class.getClassLoader(), SESS_PROXY_INTERFACES, (InvocationHandler)new TransactionProtectionWrapper(session));
    }

    public static void bind(Session session) {
        SessionFactory factory = session.getSessionFactory();
        ThreadLocalSessionContext.cleanupAnyOrphanedSession(factory);
        ThreadLocalSessionContext.doBind(session, factory);
    }

    private static void cleanupAnyOrphanedSession(SessionFactory factory) {
        org.hibernate.classic.Session orphan = ThreadLocalSessionContext.doUnbind(factory, false);
        if (orphan != null) {
            log.warn((Object)"Already session bound on call to bind(); make sure you clean up your sessions!");
            try {
                if (orphan.getTransaction() != null && orphan.getTransaction().isActive()) {
                    try {
                        orphan.getTransaction().rollback();
                    }
                    catch (Throwable t) {
                        log.debug((Object)"Unable to rollback transaction for orphaned session", t);
                    }
                }
                orphan.close();
            }
            catch (Throwable t) {
                log.debug((Object)"Unable to close orphaned session", t);
            }
        }
    }

    public static org.hibernate.classic.Session unbind(SessionFactory factory) {
        return ThreadLocalSessionContext.doUnbind(factory, true);
    }

    private static org.hibernate.classic.Session existingSession(SessionFactory factory) {
        Map sessionMap = ThreadLocalSessionContext.sessionMap();
        if (sessionMap == null) {
            return null;
        }
        return (org.hibernate.classic.Session)sessionMap.get(factory);
    }

    private static Map sessionMap() {
        return (Map)context.get();
    }

    private static void doBind(Session session, SessionFactory factory) {
        HashMap<SessionFactory, Session> sessionMap = ThreadLocalSessionContext.sessionMap();
        if (sessionMap == null) {
            sessionMap = new HashMap<SessionFactory, Session>();
            context.set(sessionMap);
        }
        sessionMap.put(factory, session);
    }

    private static org.hibernate.classic.Session doUnbind(SessionFactory factory, boolean releaseMapIfEmpty) {
        Map sessionMap = ThreadLocalSessionContext.sessionMap();
        org.hibernate.classic.Session session = null;
        if (sessionMap != null) {
            session = (org.hibernate.classic.Session)sessionMap.remove(factory);
            if (releaseMapIfEmpty && !sessionMap.isEmpty()) {
                context.set(null);
            }
        }
        return session;
    }

    private static class TransactionProtectionWrapper
    implements InvocationHandler,
    Serializable {
        private final org.hibernate.classic.Session realSession;

        public TransactionProtectionWrapper(org.hibernate.classic.Session realSession) {
            this.realSession = realSession;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("close".equals(method.getName())) {
                    ThreadLocalSessionContext.unbind(this.realSession.getSessionFactory());
                    return method.invoke((Object)this.realSession, args);
                }
                if (!this.realSession.getTransaction().isActive()) {
                    if ("beginTransaction".equals(method.getName()) || "getTransaction".equals(method.getName()) || "isTransactionInProgress".equals(method.getName()) || "isOpen".equals(method.getName())) {
                        log.trace((Object)("allowing method [" + method.getName() + "] is non-transacted context"));
                    } else {
                        throw new HibernateException(method.getName() + " is not valid without active transaction");
                    }
                }
                return method.invoke((Object)this.realSession, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw e;
            }
        }
    }

    protected static class CleanupSynch
    implements Synchronization,
    Serializable {
        private final SessionFactory factory;

        public CleanupSynch(SessionFactory factory) {
            this.factory = factory;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            ThreadLocalSessionContext.unbind(this.factory);
        }
    }
}

