/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.action.Executable;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.StringHelper;

public abstract class EntityAction
implements Executable,
Serializable,
Comparable {
    private final SessionImplementor session;
    private final Serializable id;
    private final Object instance;
    private final String entityName;
    private transient EntityPersister persister;

    protected EntityAction(SessionImplementor session, Serializable id, Object instance, EntityPersister persister) {
        this.session = session;
        this.id = id;
        this.persister = persister;
        this.instance = instance;
        this.entityName = persister.getEntityName();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.persister = this.session.getFactory().getEntityPersister(this.entityName);
    }

    public final Serializable[] getPropertySpaces() {
        return this.persister.getPropertySpaces();
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected final Serializable getId() {
        return this.id;
    }

    protected final EntityPersister getPersister() {
        return this.persister;
    }

    protected final Object getInstance() {
        return this.instance;
    }

    public void beforeExecutions() {
        throw new AssertionFailure("beforeExecutions() called for non-collection action");
    }

    public boolean hasAfterTransactionCompletion() {
        return this.persister.hasCache() || this.hasPostCommitEventListeners();
    }

    protected abstract boolean hasPostCommitEventListeners();

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.entityName, this.id);
    }

    public int compareTo(Object other) {
        EntityAction action = (EntityAction)other;
        int roleComparison = this.entityName.compareTo(action.entityName);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.persister.getIdentifierType().compare(this.id, action.id, this.session.getEntityMode());
    }
}

