/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterWrapping;
import org.jboss.axis.providers.java.RPCInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.webservice.Constants;

public class ServiceEndpointInterceptor
extends AbstractInterceptor {
    public Object invoke(Invocation mi) throws Exception {
        org.jboss.axis.MessageContext msgContext = (org.jboss.axis.MessageContext)mi.getPayloadValue((Object)InvocationKey.SOAP_MESSAGE_CONTEXT);
        if (msgContext == null) {
            return this.getNext().invoke(mi);
        }
        HandlerChain handlerChain = (HandlerChain)msgContext.getProperty(Constants.HANDLER_CHAIN);
        if (handlerChain == null) {
            throw new IllegalStateException("Cannot obtain handler chain from msg context");
        }
        RPCInvocation invocation = (RPCInvocation)msgContext.getProperty("axis.provider.java.rpc-invocation");
        if (invocation == null) {
            throw new IllegalStateException("Cannot obtain RPCInvocation from message context");
        }
        try {
            if (!handlerChain.handleRequest((MessageContext)msgContext)) {
                this.log.warn((Object)"FIXME: handlerChain.handleRequest() returned false");
                return null;
            }
            RPCInvocation invAfterRequestHandler = (RPCInvocation)msgContext.getProperty("axis.provider.java.rpc-invocation");
            if (!invocation.equals(invAfterRequestHandler)) {
                Object[] args = invAfterRequestHandler.getArgValues();
                if (args.length != mi.getArguments().length) {
                    throw new IllegalArgumentException("Invalid argument list in RPCInvocation");
                }
                for (int i = 0; i < args.length; ++i) {
                    Class<?> rpcClass;
                    Class<?> miClass = mi.getArguments()[i].getClass();
                    if (!miClass.isAssignableFrom(rpcClass = args[i].getClass())) {
                        throw new IllegalArgumentException("RPCInvocation argument cannot be assigned: " + miClass.getName() + " != " + rpcClass.getName());
                    }
                    mi.getArguments()[i] = args[i];
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing request handler chain", (Throwable)e);
            throw e;
        }
        Object resObj = null;
        try {
            resObj = this.getNext().invoke(mi);
        }
        catch (Exception e) {
            msgContext.setProperty(Constants.LAST_FAULT, (Object)e);
            this.log.error((Object)"Error from service endpoint, processing fault handler chain", (Throwable)e);
            if (!handlerChain.handleFault((MessageContext)msgContext)) {
                this.log.warn((Object)"FIXME: handlerChain.handleFault() returned false");
                return null;
            }
            throw e;
        }
        try {
            OperationDesc opDesc = msgContext.getOperation();
            if (opDesc.isWrapParameters()) {
                resObj = ParameterWrapping.wrapResponseParameter((OperationDesc)opDesc, (Object)resObj);
            }
            invocation.prepareResponseEnvelope(resObj);
            if (!handlerChain.handleResponse((MessageContext)msgContext)) {
                this.log.warn((Object)"FIXME: handlerChain.handleResponse() returned false");
                return null;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing response handler chain", (Throwable)e);
            throw e;
        }
        return resObj;
    }
}

