/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Handler;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.description.ParameterWrapping;
import org.jboss.axis.enums.Style;
import org.jboss.axis.enums.Use;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.providers.java.RPCInvocation;
import org.jboss.axis.providers.java.RPCProvider;
import org.jboss.axis.transport.http.HTTPConstants;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.deployment.BeanXMLMetaData;
import org.jboss.webservice.deployment.MetaDataRegistry;
import org.jboss.webservice.handler.ServerHandlerChain;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.webservice.metadata.serviceref.InitParamMetaData;
import org.jboss.webservice.server.JBossRPCInvocation;
import org.jboss.webservice.server.ServiceException;
import org.jboss.webservice.server.WSDLRequestHandler;
import org.w3c.dom.Document;

public abstract class InvokerProvider
extends RPCProvider {
    static final long serialVersionUID = 3036485550614460123L;
    private Logger log = Logger.getLogger((Class)InvokerProvider.class);
    protected MBeanServer server;
    protected PortComponentInfo portComponentInfo;
    protected ServerHandlerChain handlerChain;

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        this.log.debug((Object)("initServiceDesc: service=" + service.getName()));
        try {
            this.server = MBeanServerLocator.locateJBoss();
            String wsID = (String)service.getOption("webserviceID");
            this.portComponentInfo = (PortComponentInfo)this.server.invoke(AxisServiceMBean.OBJECT_NAME, "getPortComponentInfo", new Object[]{wsID}, new String[]{String.class.getName()});
            if (this.portComponentInfo == null) {
                throw new ServiceException("Cannot obtain port component info for: " + wsID);
            }
            this.initHandlerChain();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot initialize webservice", e);
        }
        super.initServiceDesc(service, msgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandlerChain() throws Exception {
        ClassLoader cl = this.getContextClassLoader();
        HashSet<String> handlerRoles = new HashSet<String>();
        ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
        HandlerMetaData[] handlers = this.portComponentInfo.getPortComponentMetaData().getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            HandlerMetaData hMetaData = handlers[i];
            handlerRoles.addAll(Arrays.asList(hMetaData.getSoapRoles()));
            Class<?> hClass = cl.loadClass(hMetaData.getHandlerClass());
            HashMap<String, String> hConfig = new HashMap<String, String>();
            InitParamMetaData[] params = hMetaData.getInitParams();
            for (int j = 0; j < params.length; ++j) {
                InitParamMetaData param = params[j];
                hConfig.put(param.getParamName(), param.getParamValue());
            }
            QName[] hHeaders = hMetaData.getSoapHeaders();
            HandlerInfo info = new HandlerInfo(hClass, hConfig, hHeaders);
            String serviceName = this.portComponentInfo.getPortComponentMetaData().getPortComponentName();
            this.log.debug((Object)("Adding server side handler to service '" + serviceName + "': " + info));
            handlerInfos.add(info);
        }
        this.handlerChain = new ServerHandlerChain(handlerInfos, handlerRoles);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            if (this.handlerChain.getState() == 1) {
                this.handlerChain.init(null);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected abstract ClassLoader getContextClassLoader();

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            throw new IllegalStateException("Cannot obtain HttpServletRequest from msg context");
        }
        try {
            String resourcePath = (String)msgContext.getProperty("axis.wsdlgen.resource");
            String requestURI = req.getRequestURI();
            String requestURL = req.getRequestURL().toString();
            String hostURL = requestURL.substring(0, requestURL.indexOf(requestURI));
            WebserviceDescriptionMetaData webserviceDescription = this.portComponentInfo.getPortComponentMetaData().getWebserviceDescription();
            DeploymentInfo di = this.portComponentInfo.getDeploymentInfo();
            WSDLRequestHandler wsdlRequestHandler = new WSDLRequestHandler(webserviceDescription, di);
            Document document = wsdlRequestHandler.getDocumentForPath(hostURL, requestURI, resourcePath);
            msgContext.setProperty("WSDL", (Object)document);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot process WSDL document", (Throwable)e);
        }
    }

    public RPCInvocation createRPCInvocation(MessageContext msgContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object obj) {
        JBossRPCInvocation invocation = new JBossRPCInvocation(this, msgContext, reqEnv, resEnv, obj);
        return invocation;
    }

    public PortComponentInfo getPortComponentInfo() {
        return this.portComponentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getServiceClass(String clsName, SOAPService service, MessageContext msgContext) throws AxisFault {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            String seiName = this.portComponentInfo.getPortComponentMetaData().getServiceEndpointInterface();
            Class clazz = super.getServiceClass(seiName, service, msgContext);
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected String getServiceClassName(Handler handler) {
        return this.portComponentInfo.getPortComponentMetaData().getServiceEndpointInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object invokeMethod(MessageContext msgContext, Method method, Object obj, Object[] args) throws Exception {
        OperationDesc opDesc = msgContext.getOperation();
        Style style = opDesc.getStyle();
        Use use = opDesc.getUse();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (style == Style.DOCUMENT && use == Use.LITERAL && opDesc.getNumInParams() == 1 && paramTypes.length >= 1) {
            ParameterDesc paramDesc = (ParameterDesc)opDesc.getInParams().get(0);
            QName typeQName = paramDesc.getTypeQName();
            Object reqStruct = args[0];
            Class<?> firstParamType = paramTypes[0];
            if (reqStruct != null && !firstParamType.isAssignableFrom(reqStruct.getClass())) {
                if (paramTypes.length == 1 && JavaUtils.isConvertable((Object)reqStruct, firstParamType, (boolean)false)) {
                    reqStruct = JavaUtils.convert((Object)reqStruct, firstParamType);
                    args = new Object[]{reqStruct};
                } else {
                    ParameterDesc retParamDesc;
                    if (paramDesc.getWrappedVariables() == null) {
                        ObjectName oname = AxisServiceMBean.OBJECT_NAME;
                        MetaDataRegistry metaDataRegistry = (MetaDataRegistry)this.server.getAttribute(oname, "MetaDataRegistry");
                        BeanXMLMetaData tmMetaData = metaDataRegistry.getTypeMappingMetaData(typeQName);
                        if (tmMetaData == null) {
                            throw new IllegalStateException("Cannot obtain type mapping meta data for: " + typeQName);
                        }
                        opDesc.setWrapParameters(true);
                        paramDesc.setWrappedVariables(tmMetaData.getElementOrder());
                    }
                    if ((retParamDesc = opDesc.getReturnParamDesc()).getWrappedVariables() == null) {
                        QName retTypeQName = retParamDesc.getTypeQName();
                        ObjectName oname = AxisServiceMBean.OBJECT_NAME;
                        MetaDataRegistry metaDataRegistry = (MetaDataRegistry)this.server.getAttribute(oname, "MetaDataRegistry");
                        BeanXMLMetaData tmMetaData = metaDataRegistry.getTypeMappingMetaData(retTypeQName);
                        if (tmMetaData == null) {
                            throw new IllegalStateException("Cannot obtain type mapping meta data for: " + retTypeQName);
                        }
                        opDesc.setWrapParameters(true);
                        retParamDesc.setWrappedVariables(tmMetaData.getElementOrder());
                    }
                    args = ParameterWrapping.unwrapRequestParameters((OperationDesc)opDesc, (Object)reqStruct);
                }
            }
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            Object retObj = this.invokeServiceEndpoint(msgContext, method, obj, args);
            ParameterDesc paramDesc = opDesc.getReturnParamDesc();
            Class resStructType = paramDesc.getJavaType();
            if (opDesc.isWrapParameters() && (retObj == null || !resStructType.isAssignableFrom(retObj.getClass()))) {
                retObj = ParameterWrapping.wrapResponseParameter((OperationDesc)opDesc, (Object)retObj);
            }
            Object object = retObj;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected abstract Object invokeServiceEndpoint(MessageContext var1, Method var2, Object var3, Object[] var4) throws Exception;
}

