/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.util.List;
import org.jboss.axis.MessageContext;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.xml.sax.SAXException;

public class DocumentDeserializer
extends DeserializerImpl {
    private static Logger log = Logger.getLogger((String)DocumentDeserializer.class.getName());
    public static final String DESERIALIZE_CURRENT_ELEMENT = "DeserializeCurrentElement";

    public final void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        try {
            SOAPElementAxisImpl msgElem = context.getCurElement();
            if (msgElem != null) {
                MessageContext messageContext = context.getMessageContext();
                Boolean currentElement = (Boolean)messageContext.getProperty(DESERIALIZE_CURRENT_ELEMENT);
                if (currentElement != null && currentElement.booleanValue()) {
                    this.value = msgElem.getAsDocument();
                    messageContext.setProperty(DESERIALIZE_CURRENT_ELEMENT, Boolean.FALSE);
                    return;
                }
                List children = msgElem.getChildren();
                if (children != null && (msgElem = (SOAPElementAxisImpl)children.get(0)) != null) {
                    this.value = msgElem.getAsDocument();
                }
            }
        }
        catch (Exception exp) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exp);
            throw new SAXException(exp);
        }
    }
}

