/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.jboss.logging.Logger;
import org.jboss.resource.work.JBossWorkManager;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.threadpool.BasicTaskWrapper;
import org.jboss.util.threadpool.StartTimeoutException;
import org.jboss.util.threadpool.Task;

public class WorkWrapper
extends BasicTaskWrapper
implements Task {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$work$WorkWrapper == null ? (class$org$jboss$resource$work$WorkWrapper = WorkWrapper.class$("org.jboss.resource.work.WorkWrapper")) : class$org$jboss$resource$work$WorkWrapper));
    private boolean trace = log.isTraceEnabled();
    private Work work;
    private ExecutionContext executionContext;
    private WorkListener workListener;
    private long startTimeout;
    private JBossWorkManager workManager;
    private int waitType;
    private long blockedTime;
    private WorkException exception;
    static /* synthetic */ Class class$org$jboss$resource$work$WorkWrapper;

    public WorkWrapper(JBossWorkManager workManager, Work work, int waitType, long startTimeout, ExecutionContext executionContext, WorkListener workListener) {
        if (work == null) {
            throw new IllegalArgumentException("Null work");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("Null execution context");
        }
        if (startTimeout < 0L) {
            throw new IllegalArgumentException("Illegal start timeout: " + startTimeout);
        }
        this.workManager = workManager;
        this.work = work;
        this.waitType = waitType;
        this.startTimeout = startTimeout;
        this.executionContext = executionContext;
        this.workListener = workListener;
        this.setTask(this);
    }

    public JBossWorkManager getWorkManager() {
        return this.workManager;
    }

    public Work getWork() {
        return this.work;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public long getBlockedElapsed() {
        return this.blockedTime;
    }

    public WorkException getWorkException() {
        return this.exception;
    }

    public int getWaitType() {
        return this.waitType;
    }

    public int getPriority() {
        return 5;
    }

    public long getStartTimeout() {
        return this.startTimeout;
    }

    public long getCompletionTimeout() {
        return this.executionContext.getTransactionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.trace) {
            log.trace((Object)("Executing work " + (Object)((Object)this)));
        }
        try {
            this.workManager.startWork(this);
        }
        catch (WorkException e) {
            this.taskRejected((RuntimeException)new NestedRuntimeException((Throwable)e));
            return;
        }
        try {
            this.work.run();
        }
        finally {
            this.workManager.endWork(this);
        }
        if (this.trace) {
            log.trace((Object)("Executed work " + (Object)((Object)this)));
        }
    }

    public void stop() {
        if (this.trace) {
            log.trace((Object)("Stopping work " + (Object)((Object)this)));
        }
        this.work.release();
    }

    public void accepted(long time) {
        this.blockedTime = time;
        if (this.trace) {
            log.trace((Object)("Accepted work " + (Object)((Object)this)));
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 1, this.work, null);
            this.workListener.workAccepted(event);
        }
    }

    public void rejected(long time, Throwable throwable) {
        this.blockedTime = time;
        if (this.trace) {
            if (throwable != null) {
                log.trace((Object)("Rejecting work " + (Object)((Object)this)), throwable);
            } else {
                log.trace((Object)("Rejecting work " + (Object)((Object)this)));
            }
        }
        if (throwable != null) {
            this.exception = new WorkRejectedException(throwable);
            if (throwable instanceof StartTimeoutException) {
                this.exception.setErrorCode("1");
            }
        }
        this.workManager.cancelWork(this);
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 1, this.work, this.exception);
            this.workListener.workRejected(event);
        }
    }

    public void started(long time) {
        if (this.waitType != 0) {
            this.blockedTime = time;
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 3, this.work, null);
            this.workListener.workStarted(event);
        }
    }

    public void completed(long time, Throwable throwable) {
        if (this.waitType == 2) {
            this.blockedTime = time;
        }
        if (throwable != null) {
            this.exception = new WorkCompletedException(throwable);
        }
        if (this.trace) {
            log.trace((Object)("Completed work " + (Object)((Object)this)));
        }
        if (this.workListener != null) {
            WorkEvent event = new WorkEvent((Object)this.workManager, 4, this.work, this.exception);
            this.workListener.workCompleted(event);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode((Object)this)));
        buffer.append("[workManger=").append(this.workManager);
        buffer.append(" work=").append(this.work);
        if (this.executionContext != null && this.executionContext.getXid() != null) {
            buffer.append(" xid=").append(this.executionContext.getXid());
            buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
        }
        buffer.append(" waitType=" + this.waitType);
        buffer.append(" startTimeout=" + this.startTimeout);
        if (this.blockedTime != 0L) {
            buffer.append(" blockTime=" + this.blockedTime);
        }
        if (this.workListener != null) {
            buffer.append(" workListener=" + this.workListener);
        }
        if (this.exception != null) {
            buffer.append(" exception=" + (Object)((Object)this.exception));
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

