/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.description;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.enums.Style;
import org.jboss.logging.Logger;

public class ParameterWrapping {
    private static Logger log = Logger.getLogger((Class)ParameterWrapping.class);

    public static Object wrapRequestParameters(OperationDesc opDesc, Object[] inParams) {
        ParameterWrapping.assertOperationDesc(opDesc);
        ParameterDesc paramDesc = (ParameterDesc)opDesc.getParameters().get(0);
        QName typeQName = paramDesc.getTypeQName();
        Class reqStructType = paramDesc.getJavaType();
        if (reqStructType == null) {
            throw new IllegalArgumentException("Cannot obtain java type for: " + typeQName);
        }
        log.debug((Object)("wrapRequestParameters: " + reqStructType.getName()));
        try {
            List varNames = paramDesc.getWrappedVariables();
            Object reqStruct = reqStructType.newInstance();
            for (int i = 0; i < varNames.size(); ++i) {
                String varName = (String)varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getWriteMethod();
                Object value = inParams[i];
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                method.invoke(reqStruct, value);
            }
            return reqStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot wrap request structure: " + e);
        }
    }

    public static Object[] unwrapRequestParameters(OperationDesc opDesc, Object reqStruct) {
        ParameterWrapping.assertOperationDesc(opDesc);
        if (reqStruct == null) {
            throw new IllegalArgumentException("Request struct cannot be null");
        }
        ParameterDesc paramDesc = (ParameterDesc)opDesc.getParameters().get(0);
        List varNames = paramDesc.getWrappedVariables();
        Class<?> reqStructType = reqStruct.getClass();
        log.debug((Object)("unwrapRequestParameters: " + reqStructType.getName()));
        Object[] inParams = new Object[varNames.size()];
        try {
            for (int i = 0; i < varNames.size(); ++i) {
                String varName = (String)varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getReadMethod();
                Object value = method.invoke(reqStruct, new Object[0]);
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                inParams[i] = value;
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
        }
        return inParams;
    }

    public static Object wrapResponseParameter(OperationDesc opDesc, Object outParam) {
        ParameterWrapping.assertOperationDesc(opDesc);
        ParameterDesc paramDesc = opDesc.getReturnParamDesc();
        QName typeQName = paramDesc.getTypeQName();
        Class resStructType = paramDesc.getJavaType();
        if (resStructType == null) {
            throw new IllegalArgumentException("Cannot obtain java type for: " + typeQName);
        }
        log.debug((Object)("wrapResponseParameter: " + resStructType.getName()));
        try {
            List varNames = paramDesc.getWrappedVariables();
            String varName = (String)varNames.get(0);
            Object resStruct = resStructType.newInstance();
            PropertyDescriptor pd = new PropertyDescriptor(varName, resStructType);
            Method method = pd.getWriteMethod();
            Object value = outParam;
            log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
            method.invoke(resStruct, value);
            return resStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot wrap response structure: " + e);
        }
    }

    public static Object unwrapResponseParameter(OperationDesc opDesc, Object resStruct) {
        ParameterWrapping.assertOperationDesc(opDesc);
        if (resStruct == null) {
            throw new IllegalArgumentException("Response struct cannot be null");
        }
        ParameterDesc paramDesc = opDesc.getReturnParamDesc();
        List varNames = paramDesc.getWrappedVariables();
        Class<?> reqStructType = resStruct.getClass();
        Object retValue = null;
        log.debug((Object)("unwrapResponseParameter: " + reqStructType.getName()));
        try {
            String varName = (String)varNames.get(0);
            PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
            Method method = pd.getReadMethod();
            Object value = method.invoke(resStruct, new Object[0]);
            log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
            retValue = value;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
        }
        return retValue;
    }

    private static void assertOperationDesc(OperationDesc opDesc) {
        if (opDesc.getStyle() != Style.DOCUMENT) {
            throw new IllegalStateException("Unexpected style: " + opDesc);
        }
        if (opDesc.getParameters().size() != 1) {
            throw new IllegalStateException("Unexpected number of input parameters for: " + opDesc);
        }
        if (opDesc.getReturnParamDesc() == null) {
            throw new IllegalStateException("Unexpected null return parameter: " + opDesc);
        }
        if (!opDesc.isWrapParameters()) {
            throw new IllegalStateException("Operation meta data not marked for wrapping: " + opDesc);
        }
        ParameterDesc paramDesc = (ParameterDesc)opDesc.getParameters().get(0);
        if (paramDesc.getWrappedVariables() == null) {
            throw new IllegalStateException("Parameter meta data does not contain a variable name list: " + paramDesc);
        }
        ParameterDesc retMetaData = opDesc.getReturnParamDesc();
        if (retMetaData.getWrappedVariables() == null) {
            throw new IllegalStateException("Return parameter meta data does not contain a variable name list: " + retMetaData);
        }
    }
}

