/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.components.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.jboss.axis.components.net.JSSESocketFactory;
import org.jboss.axis.components.net.SecureSocketFactory;
import org.jboss.logging.Logger;

public class JSSE14SocketFactory
extends JSSESocketFactory
implements SecureSocketFactory {
    private static Logger log = Logger.getLogger((Class)JSSE14SocketFactory.class);
    static String defaultKeyStoreType = "JKS";
    static String defaultProtocol = "TLS";
    static String defaultAlgorithm = "SunX509";
    static String defaultKeyStorePassword = "changeit";

    public JSSE14SocketFactory(HashMap options) {
        super(options == null ? new HashMap() : options);
    }

    protected String getKeyStoreType() {
        String keyStoreType = (String)this.options.get("org.jboss.webservice.keyStoreType");
        if (keyStoreType == null) {
            keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        }
        if (keyStoreType == null) {
            keyStoreType = defaultKeyStoreType;
        }
        return keyStoreType;
    }

    protected String getTrustStorePassword() {
        String trustStorePassword = (String)this.options.get("org.jboss.webservice.trustStorePassword");
        if (trustStorePassword == null) {
            trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (trustStorePassword == null) {
            trustStorePassword = this.getKeyStorePassword();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TrustPass = " + trustStorePassword));
        }
        return trustStorePassword;
    }

    protected String getTrustStoreType() {
        String truststoreType = (String)this.options.get("org.jboss.webservice.trustStoreType");
        if (truststoreType == null) {
            truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (truststoreType == null) {
            truststoreType = defaultKeyStoreType;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trustType = " + truststoreType));
        }
        return truststoreType;
    }

    protected void initFactory() throws IOException {
        try {
            String trustAlgorithm;
            String algorithm;
            String protocol = (String)this.options.get("org.jboss.webservice.protocol");
            if (protocol == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.options.get("org.jboss.webservice.algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            if ((trustAlgorithm = (String)this.options.get("org.jboss.webservice.truststoreAlgorithm")) == null) {
                trustAlgorithm = algorithm;
            }
            String keyStoreType = this.getKeyStoreType();
            String trustStoreType = this.getTrustStoreType();
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(this.getKeyManagers(keyStoreType, algorithm, (String)this.options.get("org.jboss.webservice.keyAlias")), this.getTrustManagers(trustAlgorithm, trustStoreType), new SecureRandom());
            this.sslFactory = context.getSocketFactory();
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String type, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        String keyStorePass = this.getKeyStorePassword();
        KeyStore ks = this.getKeyStore(type, keyStorePass);
        if (ks == null) {
            return null;
        }
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException("Could not find alias in keyStore: " + keyAlias);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keyStorePass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if (defaultKeyStoreType.equals(type)) {
                keyAlias = keyAlias.toLowerCase();
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected String getKeyStorePassword() {
        String keyStorePassword = (String)this.options.get("org.jboss.webservice.keyStorePassword");
        if (keyStorePassword == null) {
            keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (keyStorePassword == null) {
            keyStorePassword = defaultKeyStorePassword;
        }
        return keyStorePassword;
    }

    protected KeyStore getKeyStore(String type, String pass) throws IOException {
        String keyStoreFile = (String)this.options.get("org.jboss.webservice.keyStore");
        if (keyStoreFile == null) {
            keyStoreFile = System.getProperty("javax.net.ssl.keyStore");
        }
        if (keyStoreFile == null) {
            return null;
        }
        return this.getStore(type, keyStoreFile, pass);
    }

    protected TrustManager[] getTrustManagers(String algorithm, String type) throws Exception {
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore(type, this.getTrustStorePassword());
        if (trustStore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(trustStore);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    protected KeyStore getTrustStore(String type, String pass) throws IOException {
        KeyStore trustStore = null;
        String trustStoreFile = (String)this.options.get("org.jboss.webservice.trustStore");
        if (trustStoreFile == null) {
            trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Truststore = " + trustStoreFile));
        }
        if (trustStoreFile != null && pass != null) {
            trustStore = this.getStore(type, trustStoreFile, pass);
        }
        return trustStore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyStore getStore(String type, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            try {
                ks = KeyStore.getInstance(type);
                URL resource = Thread.currentThread().getContextClassLoader().getResource(path);
                if (resource != null) {
                    istream = resource.openStream();
                } else {
                    File keyStoreFile = new File(path);
                    istream = new FileInputStream(keyStoreFile);
                }
                ks.load(istream, pass.toCharArray());
                istream.close();
                return ks;
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException("Exception trying to load keystore " + path + ": " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static final class JSSEKeyManager
    implements X509KeyManager {
        private X509KeyManager delegate;
        private String clientKeyAlias;

        public JSSEKeyManager(X509KeyManager mgr, String clientKeyAlias) {
            this.delegate = mgr;
            this.clientKeyAlias = clientKeyAlias;
        }

        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.clientKeyAlias;
        }

        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.delegate.chooseServerAlias(keyType, issuers, socket);
        }

        public X509Certificate[] getCertificateChain(String alias) {
            return this.delegate.getCertificateChain(alias);
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.delegate.getClientAliases(keyType, issuers);
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.delegate.getServerAliases(keyType, issuers);
        }

        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }
    }
}

