/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.InputStream;
import java.io.Reader;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.MetadataDrivenObjectModelFactory;
import org.jboss.xb.binding.ObjectModelBuilder;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.metadata.unmarshalling.BindingCursor;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBindingFactory;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBindingStack;
import org.jboss.xb.binding.metadata.unmarshalling.impl.RuntimeDocumentBinding;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.parser.sax.SaxJBossXBParser;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class UnmarshallerImpl
implements Unmarshaller {
    private ObjectModelBuilder builder = new ObjectModelBuilder();
    private final JBossXBParser parser = new SaxJBossXBParser();

    public UnmarshallerImpl() throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/validation", true);
        this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
        this.parser.setEntityResolver((EntityResolver)new JBossEntityResolver());
    }

    public void setValidation(boolean validation) throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/validation", validation);
    }

    public void setNamespaceAware(boolean namespaces) throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/namespaces", namespaces);
    }

    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        this.parser.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri) {
        this.builder.mapFactoryToNamespace(factory, namespaceUri);
    }

    public Object unmarshal(String xmlFile) throws JBossXBException {
        DocumentBindingStack docBinding = DocumentBindingFactory.newInstance().newDocumentBindingStack().push(RuntimeDocumentBinding.class);
        BindingCursor cursor = BindingCursor.Factory.newCursor(docBinding);
        this.builder.init(new MetadataDrivenObjectModelFactory(), null, cursor);
        this.parser.parse(xmlFile, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(String xmlFile, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.parser.parse(xmlFile, handler);
        return handler.getRoot();
    }

    public Object unmarshal(String xml, SchemaBinding schemaBinding) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaBinding);
        this.parser.parse(xml, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(Reader xmlReader, SchemaBinding schemaBinding) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaBinding);
        this.parser.parse(xmlReader, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(InputStream xmlStream, SchemaBinding schemaBinding) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaBinding);
        this.parser.parse(xmlStream, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(String xml, SchemaBindingResolver schemaResolver) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaResolver);
        this.parser.parse(xml, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(Reader xmlReader, SchemaBindingResolver schemaResolver) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaResolver);
        this.parser.parse(xmlReader, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(InputStream xmlStream, SchemaBindingResolver schemaResolver) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaResolver);
        this.parser.parse(xmlStream, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(String xmlFile, ObjectModelFactory factory, DocumentBinding metadata) throws JBossXBException {
        BindingCursor cursor = BindingCursor.Factory.newCursor(metadata);
        this.builder.init(factory, null, cursor);
        this.parser.parse(xmlFile, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(Reader xmlFile, ObjectModelFactory factory, DocumentBinding metadata) throws JBossXBException {
        BindingCursor cursor = BindingCursor.Factory.newCursor(metadata);
        this.builder.init(factory, null, cursor);
        this.parser.parse(xmlFile, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(Reader reader, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(factory, root, BindingCursor.Factory.newCursor(null));
        this.parser.parse(reader, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(InputStream is, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(factory, root, BindingCursor.Factory.newCursor(null));
        this.parser.parse(is, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(String systemId, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(factory, root, BindingCursor.Factory.newCursor(null));
        this.parser.parse(systemId, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(String systemId, BindingCursor cursor, ObjectModelFactory factory) throws JBossXBException {
        this.builder.init(factory, null, cursor);
        this.parser.parse(systemId, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }
}

