/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;

public class RMIServerInvoker
extends ServerInvoker
implements RMIServerInvokerInf {
    private Remote stub;
    public static final int DEFAULT_REGISTRY_PORT = 3455;
    public static final String REGISTRY_PORT_KEY = "registryPort";
    private Marshaller marshaller = null;
    private UnMarshaller unmarshaller = null;

    public RMIServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    protected void setup() throws Exception {
        super.setup();
        int bindPort = this.getServerBindPort();
        Registry registry = null;
        registry = this.getRegistry();
        this.stub = UnicastRemoteObject.exportObject((Remote)this, bindPort);
        this.log.debug((Object)("Binding registry to remoting/RMIServerInvoker/" + bindPort));
        registry.rebind("remoting/RMIServerInvoker/" + bindPort, this);
        this.unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), this.getClass().getClassLoader());
        this.marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClass().getClassLoader());
    }

    public RMIServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    private Registry getRegistry() throws Exception {
        String value;
        Registry registry = null;
        int port = 3455;
        Map params = this.getConfiguration();
        if (params != null && (value = (String)params.get(REGISTRY_PORT_KEY)) != null) {
            try {
                port = Integer.parseInt(value);
                this.log.debug((Object)("Using port " + port + " for rmi registry."));
            }
            catch (NumberFormatException e) {
                throw new Exception("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
            }
        }
        try {
            this.log.debug((Object)("Creating registry for " + port));
            registry = LocateRegistry.createRegistry(port);
        }
        catch (ExportException exportEx) {
            this.log.debug((Object)("Locating registry for " + port));
            registry = LocateRegistry.getRegistry(port);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Got registry: " + registry));
        }
        return registry;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void destroy() {
        super.destroy();
        try {
            try {
                this.log.debug((Object)("unbinding remoting/RMIServerInvoker/" + this.locator.getPort() + " from registry running on port " + (this.locator.getPort() + 1)));
                Registry registry = this.getRegistry();
                registry.unbind("remoting/RMIServerInvoker/" + this.locator.getPort());
            }
            catch (Exception e) {
                this.log.error((Object)"Error unbinding RMIServerInvoker from RMI registry.", (Throwable)e);
            }
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    public final Remote getStub() {
        return this.stub;
    }

    public Object transport(Object invocation) throws RemoteException, IOException {
        Object payload = invocation;
        if (this.unmarshaller != null) {
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream();
            pos.connect(pis);
            ObjectOutputStream oos = new ObjectOutputStream(pos);
            oos.writeObject(payload);
            oos.flush();
            oos.reset();
            try {
                oos.close();
                payload = this.unmarshaller.read(pis, null);
                pis.close();
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("Could not unmarshall invocation request" + payload), (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
        Object response = this.invoke(payload);
        return response;
    }
}

