/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.InputMultiplexor;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.OutputMultiplexor;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class MultiplexingManager {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$MultiplexingManager == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexingManager = MultiplexingManager.class$("org.jboss.remoting.transport.multiplex.MultiplexingManager")) : class$org$jboss$remoting$transport$multiplex$MultiplexingManager));
    private static Map managersByLocalAddress = Collections.synchronizedMap(new HashMap());
    private static Map managersByRemoteAddress = Collections.synchronizedMap(new HashMap());
    private OutputMultiplexor outputMultiplexor;
    private Map socketMap = Collections.synchronizedMap(new HashMap());
    private Set connectedRemoteSockets = Collections.synchronizedSet(new HashSet());
    private Map outputStreamMap = Collections.synchronizedMap(new HashMap());
    private Protocol protocol;
    private Socket socket;
    private boolean bound = false;
    private boolean connected = false;
    private InetSocketAddress remoteSocketAddress;
    private InetSocketAddress localSocketAddress;
    private InetSocketAddress localWildCardAddress;
    private ServerSocket serverSocket;
    private boolean remoteServerSocketRegistered = false;
    private InputMultiplexor.InputThread inputThread;
    private OutputMultiplexor.OutputThread outputThread;
    private Protocol.BackChannelThread backChannelThread;
    private OutputStream deadLetterOutputStream = new ByteArrayOutputStream();
    private int referenceCount = 0;
    public static final boolean ON_CLIENT = true;
    public static final boolean ON_SERVER = false;
    private static boolean isOnClient = false;
    private boolean running;
    private boolean trace;
    private long id;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexingManager;

    protected MultiplexingManager() {
        this.id = new Date().getTime();
        this.socket = new Socket();
        try {
            this.socket.setReuseAddress(true);
        }
        catch (SocketException ignored) {
            log.error((Object)ignored);
        }
    }

    protected MultiplexingManager(Socket socket) throws IOException {
        this.socket = socket;
        this.id = new Date().getTime();
        this.setup();
    }

    protected MultiplexingManager(String host, int port) throws UnknownHostException, IOException {
        this.socket = new Socket();
        this.id = new Date().getTime();
        try {
            this.socket.setReuseAddress(true);
        }
        catch (SocketException ignored) {
            log.error((Object)ignored);
        }
        this.socket.connect(new InetSocketAddress(host, port));
        this.setup();
    }

    protected MultiplexingManager(InetSocketAddress address) throws IOException {
        this.socket = new Socket();
        try {
            this.socket.setReuseAddress(true);
        }
        catch (SocketException ignored) {
            log.error((Object)ignored);
        }
        this.socket.connect(address);
        this.setup();
    }

    protected synchronized void setup() throws IOException {
        this.outputStreamMap.put(SocketId.DEADLETTER_SOCKET_ID, this.deadLetterOutputStream);
        this.connectedRemoteSockets.add(SocketId.PROTOCOL_SOCKET_ID);
        this.connectedRemoteSockets.add(SocketId.SERVER_SOCKET_ID);
        this.connectedRemoteSockets.add(SocketId.BACKCHANNEL_SOCKET_ID);
        this.outputMultiplexor = new OutputMultiplexor(this, this.socket.getOutputStream());
        this.outputThread = this.outputMultiplexor.getAnOutputThread();
        this.outputThread.start();
        this.inputThread = InputMultiplexor.getAnInputThread(this, this.socket.getInputStream(), this.deadLetterOutputStream);
        this.inputThread.start();
        this.protocol = new Protocol(this);
        this.backChannelThread = this.protocol.getBackChannelThread();
        this.backChannelThread.start();
        if (!this.bound) {
            this.bound = true;
            this.registerByLocalAddress(new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort()));
        }
        if (!this.connected) {
            this.connected = true;
            this.registerByRemoteAddress(new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort()));
        }
        this.trace = log.isTraceEnabled();
    }

    public static MultiplexingManager getaManager(int port) throws IOException {
        log.debug((Object)"entering getaManager(int port)");
        return MultiplexingManager.getaManagerByLocalAddress(new InetSocketAddress(port));
    }

    public static MultiplexingManager getaManager(Socket socket) throws IOException {
        log.debug((Object)"entering getaManager(Socket socket");
        return new MultiplexingManager(socket);
    }

    public static synchronized MultiplexingManager getaManagerByLocalAddress(InetSocketAddress address) throws IOException {
        log.debug((Object)"entering getaManagerByLocalAddress(InetSocketAddress address)");
        MultiplexingManager m = (MultiplexingManager)managersByLocalAddress.get(address);
        if (m != null) {
            return m;
        }
        m = new MultiplexingManager();
        m.bind(address);
        return m;
    }

    public static synchronized MultiplexingManager getaManagerByRemoteAddress(InetSocketAddress address) throws IOException {
        log.debug((Object)"entering getaManagerByRemoteAddress(InetSocketAddress address)");
        MultiplexingManager m = (MultiplexingManager)managersByRemoteAddress.get(address);
        try {
            if (m != null && m.getProtocol().isRemoteServerSocketRegistered()) {
                return m;
            }
        }
        catch (Exception e) {
            log.info((Object)(m.getSocket().toString() + ": unable to call isRemoteServerSocketRegistered(): shutting down"));
            m.shutdown();
        }
        return new MultiplexingManager(address);
    }

    public static boolean isOnClient() {
        return isOnClient;
    }

    public static void setOnClient(boolean isOnClient) {
        log.info((Object)("setting onClient: " + isOnClient));
        MultiplexingManager.isOnClient = isOnClient;
    }

    public synchronized void incrementReferences() {
        ++this.referenceCount;
        log.info((Object)(this.socket.toString() + ": incrementReferences(): number of references: " + this.referenceCount));
    }

    public synchronized void releaseReference() {
        --this.referenceCount;
        log.info((Object)(this.socket.toString() + "releaseReference(): number of references: " + this.referenceCount));
        if (this.referenceCount == 0) {
            managersByLocalAddress.remove(this.localSocketAddress);
            log.info((Object)(this.socket.toString() + ": deleting local reference: " + this.localSocketAddress));
            managersByLocalAddress.remove(this.localWildCardAddress);
            log.info((Object)(this.socket.toString() + ": deleting local reference: " + this.localWildCardAddress));
            managersByRemoteAddress.remove(this.remoteSocketAddress);
            log.info((Object)(this.socket.toString() + ": deleting remote reference: " + this.remoteSocketAddress));
            this.shutdown();
        }
    }

    public synchronized int getReferenceCount() {
        return this.referenceCount;
    }

    public synchronized void bind(InetSocketAddress address) throws IOException {
        if (this.bound) {
            throw new IOException("socket is already bound");
        }
        this.socket.bind(address);
        this.registerByLocalAddress(address);
        this.bound = true;
    }

    protected synchronized void registerByLocalAddress(InetSocketAddress address) {
        this.localSocketAddress = address;
        managersByLocalAddress.put(address, this);
        this.localWildCardAddress = new InetSocketAddress(address.getPort());
        managersByLocalAddress.put(this.localWildCardAddress, this);
    }

    protected synchronized void registerByRemoteAddress(InetSocketAddress address) {
        this.remoteSocketAddress = address;
        managersByRemoteAddress.put(address, this);
    }

    public synchronized void connect(InetSocketAddress address) throws IOException {
        if (this.connected) {
            if (this.socket.getRemoteSocketAddress().equals(address)) {
                return;
            }
            throw new IOException("socket is already connected");
        }
        if (this.socket == null) {
            this.socket = new Socket();
        }
        log.info((Object)("connecting to: " + address));
        this.socket.connect(address);
        this.registerByRemoteAddress(address);
        this.connected = true;
        this.setup();
    }

    public synchronized void registerServerSocket(ServerSocket serverSocket) throws IOException {
        if (this.serverSocket != null && this.serverSocket != serverSocket) {
            log.error((Object)("[" + this.id + "]: " + "attempt to register a second server socket"));
            log.error((Object)("current server socket: " + this.serverSocket.toString()));
            log.error((Object)("new server socket:     " + serverSocket.toString()));
            throw new IOException("attempt to register a second server socket");
        }
        log.info((Object)("[" + this.id + "]: " + "server socket registering: " + serverSocket.toString()));
        this.serverSocket = serverSocket;
        this.incrementReferences();
    }

    public synchronized void unRegisterServerSocket(ServerSocket serverSocket) throws IOException {
        if (this.serverSocket != serverSocket) {
            log.error((Object)"server socket attempting unregister but is not registered");
            throw new IOException("server socket is not registered");
        }
        log.info((Object)"server socket unregistering");
        this.serverSocket = null;
        this.releaseReference();
    }

    public synchronized StreamPair registerSocket(VirtualSocket socket) throws IOException {
        SocketId localSocketId = socket.getLocalSocketId();
        VirtualSocket currentSocket = this.socketMap.put(localSocketId, socket);
        if (currentSocket != null) {
            String errorMessage = "attempting to register socket on currently used port:" + currentSocket.getLocalVirtualPort();
            log.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        log.info((Object)("registering virtual socket on port: " + localSocketId.getPort()));
        this.connectedRemoteSockets.add(socket.getRemoteSocketId());
        this.incrementReferences();
        MultiplexingInputStream is = this.getAnInputStream(localSocketId, null);
        MultiplexingOutputStream os = new MultiplexingOutputStream(this, socket, socket.getRemoteSocketId());
        return new StreamPair(is, os);
    }

    public synchronized void unRegisterSocket(VirtualSocket socket) throws IOException {
        SocketId localSocketId = socket.getLocalSocketId();
        VirtualSocket currentSocket = (VirtualSocket)this.socketMap.remove(localSocketId);
        if (currentSocket == null) {
            String errorMessage = "attempting to unregister unrecognized socket";
            log.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        log.info((Object)("unregistering virtual socket on port: " + localSocketId.getPort()));
        this.connectedRemoteSockets.remove(socket.getRemoteSocketId());
        this.releaseReference();
    }

    public synchronized void registerRemoteServerSocket() {
        if (this.remoteServerSocketRegistered) {
            log.error((Object)"duplicate remote server socket registration");
        } else {
            this.remoteServerSocketRegistered = true;
            this.incrementReferences();
        }
    }

    public synchronized void unRegisterRemoteServerSocket() {
        if (!this.remoteServerSocketRegistered) {
            log.error((Object)"no remote server socket is registered");
        } else {
            this.remoteServerSocketRegistered = false;
            this.releaseReference();
        }
    }

    public MultiplexingInputStream getAnInputStream(SocketId socketId, VirtualSocket socket) throws IOException {
        PipedOutputStream pos = new PipedOutputStream();
        MultiplexingInputStream mis = new MultiplexingInputStream(pos, socket);
        this.outputStreamMap.put(socketId, pos);
        return mis;
    }

    public boolean isConnectedRemoteSocket(SocketId socketId) {
        return this.connectedRemoteSockets.contains(socketId);
    }

    public synchronized boolean isServerSocketRegistered() {
        return this.serverSocket != null;
    }

    public synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public OutputStream getOutputStreamByLocalSocket(SocketId socketId) {
        return (OutputStream)this.outputStreamMap.get(socketId);
    }

    public Collection getAllOutputStreams() {
        return this.outputStreamMap.values();
    }

    public VirtualSocket getSocketByLocalPort(SocketId socketId) {
        return (VirtualSocket)this.socketMap.get(socketId);
    }

    public OutputMultiplexor getOutputMultiplexor() {
        return this.outputMultiplexor;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void shutdown() {
        new ShutdownThread().start();
        if (this.isConnected()) {
            this.protocol.notifyOfManagerShutdown();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class StreamPair {
        MultiplexingInputStream is;
        MultiplexingOutputStream os;

        public StreamPair(MultiplexingInputStream is, MultiplexingOutputStream os) {
            this.is = is;
            this.os = os;
        }

        public MultiplexingInputStream getInputStream() {
            return this.is;
        }

        public MultiplexingOutputStream getOutputStream() {
            return this.os;
        }
    }

    protected class ShutdownThread
    extends Thread {
        protected ShutdownThread() {
        }

        public void run() {
            log.info((Object)(MultiplexingManager.this.socket.toString() + ": manager shutting down"));
            MultiplexingManager.this.running = false;
            if (MultiplexingManager.this.outputThread != null) {
                MultiplexingManager.this.outputThread.shutdown();
                try {
                    MultiplexingManager.this.outputThread.join();
                    log.info((Object)"manager: joined output thread");
                }
                catch (InterruptedException ignored) {
                    log.debug((Object)"interrupted exception waiting for write thread");
                }
            }
            if (MultiplexingManager.this.socket != null) {
                try {
                    MultiplexingManager.this.socket.close();
                    log.info((Object)"manager: closed socket");
                }
                catch (IOException e) {
                    log.error((Object)"manager: unable to close socket");
                }
            }
            if (MultiplexingManager.this.backChannelThread != null) {
                MultiplexingManager.this.backChannelThread.shutdown();
                try {
                    MultiplexingManager.this.backChannelThread.join();
                    log.info((Object)"manager: joined back channel thread");
                }
                catch (InterruptedException ignored) {
                    log.debug((Object)"manager: interrupted exception waiting for back channel thread");
                }
            }
            if (MultiplexingManager.this.inputThread != null) {
                MultiplexingManager.this.inputThread.shutdown();
                try {
                    MultiplexingManager.this.inputThread.join();
                    log.info((Object)"manager: joined input thread");
                }
                catch (InterruptedException ignored) {
                    log.debug((Object)"manager: interrupted exception waiting for read thread");
                }
            }
            log.info((Object)"manager shut down");
        }
    }
}

