/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.monitor.bean.ScopeInfoData;
import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.monitor.factory.DeleteStatus;
import com.clustercontrol.monitor.factory.EventBatchConfirmProperty;
import com.clustercontrol.monitor.factory.EventFilterProperty;
import com.clustercontrol.monitor.factory.EventInfoProperty;
import com.clustercontrol.monitor.factory.ManageStatus;
import com.clustercontrol.monitor.factory.ModifyEventConfirm;
import com.clustercontrol.monitor.factory.SelectEvent;
import com.clustercontrol.monitor.factory.SelectScope;
import com.clustercontrol.monitor.factory.SelectStatus;
import com.clustercontrol.monitor.factory.StatusFilterProperty;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public abstract class MonitorControllerBean
implements SessionBean {
    public static final int ALL = 0;
    public static final int ONE_LEVEL = 1;
    public static final int ONLY = -1;
    protected static Log m_log = LogFactory.getLog(MonitorControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("MonitorController", "MON");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("addQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        JobDetail job = new JobDetail("MonitorController", "MON", EJBInvokerJob.class);
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        job.setDurability(true);
        job.getJobDataMap().put("ejb", "MonitorController");
        job.getJobDataMap().put("method", "manageStatus");
        CronTrigger cronTrigger = new CronTrigger("MonitorController", "MON");
        cronTrigger.setMisfireInstruction(2);
        cronTrigger.setCronExpression(cronString);
        try {
            manager.addSchedule(job, (Trigger)cronTrigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("MonitorController", "MON");
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("deleteQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Property getStatusFilterProperty(Locale locale) {
        StatusFilterProperty status = new StatusFilterProperty();
        return status.getProperty(locale);
    }

    public Property getEventFilterProperty(Locale locale) {
        EventFilterProperty event = new EventFilterProperty();
        return event.getProperty(locale);
    }

    public Property getEventBatchConfirmProperty(Locale locale) {
        EventBatchConfirmProperty confirm = new EventBatchConfirmProperty();
        return confirm.getProperty(locale);
    }

    public ArrayList getScopeList(String facilityId) throws CreateException, FinderException, NamingException {
        SelectScope select = new SelectScope();
        ArrayList<ScopeInfoData> list = select.getScopeList(facilityId);
        return list;
    }

    public ArrayList getStatusList(String facilityId) throws CreateException, FinderException, NamingException {
        SelectStatus select = new SelectStatus();
        ArrayList<StatusInfoData> list = select.getStatusList(facilityId, 0);
        return list;
    }

    public boolean deleteStatus(List list) throws FinderException, RemoveException, NamingException {
        DeleteStatus status = new DeleteStatus();
        return status.delete(list);
    }

    public ArrayList getStatusList(String facilityId, Property property) throws CreateException, FinderException, NamingException {
        SelectStatus select = new SelectStatus();
        ArrayList list = select.getStatusList(facilityId, property);
        return list;
    }

    public void manageStatus() throws RemoveException, FinderException, NamingException {
        ManageStatus manage = new ManageStatus();
        manage.execute();
    }

    public ViewListInfo getEventList(String facilityId, int messages) throws CreateException, FinderException, NamingException, SQLException {
        SelectEvent select = new SelectEvent();
        ViewListInfo list = select.getEventList(facilityId, 0, messages);
        return list;
    }

    public ViewListInfo getEventList(String facilityId, Property property, int messages) throws CreateException, FinderException, NamingException, SQLException {
        SelectEvent select = new SelectEvent();
        ViewListInfo list = select.getEventList(facilityId, property, messages);
        return list;
    }

    public ArrayList getEventListForReport(String facilityId, Property property) throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {
        SelectEvent select = new SelectEvent();
        ArrayList list = select.getEventListForReport(facilityId, property);
        return list;
    }

    public Property getEventInfoProperty(String monitorId, String pluginId, String facilityId, Date outputDate, Locale locale) throws FinderException, NamingException {
        EventInfoProperty event = new EventInfoProperty();
        return event.getProperty(monitorId, pluginId, facilityId, outputDate, locale);
    }

    public void modifyConfirm(String monitorId, String pluginId, String facilityId, Date outputDate, Date confirmDate, int confirmType) throws CreateException, FinderException, NamingException {
        String confirmUser = this.m_context.getCallerPrincipal().getName();
        ModifyEventConfirm modify = new ModifyEventConfirm();
        modify.modifyConfirm(monitorId, pluginId, facilityId, outputDate, confirmDate, confirmType, confirmUser);
    }

    public void modifyConfirm(List list, int confirmType) throws CreateException, FinderException, NamingException {
        String confirmUser = this.m_context.getCallerPrincipal().getName();
        ModifyEventConfirm modify = new ModifyEventConfirm();
        modify.modifyConfirm(list, confirmType, confirmUser);
    }

    public void modifyBatchConfirm(int confirmType, String facilityId, Property property) throws CreateException, NamingException, FinderException, SQLException {
        String confirmUser = this.m_context.getCallerPrincipal().getName();
        ModifyEventConfirm modify = new ModifyEventConfirm();
        modify.modifyBatchConfirm(confirmType, facilityId, property, confirmUser);
    }
}

