/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.accesscontrol.util.TimeKeeper;
import com.clustercontrol.accesscontrol.util.TimeKeeperService;
import com.clustercontrol.repository.dao.FileSystemInfoDAO;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoBean;
import com.clustercontrol.repository.ejb.entity.FileSystemInfoPK;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemInfoDAOImpl
implements FileSystemInfoDAO {
    protected static Log m_log = LogFactory.getLog(FileSystemInfoDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=facility";
    protected static final String OBJECT_CLASS_FILE_SYSTEM_INFO = "ccFileSystemInfo";
    private static int MAX_RETRY = 3;

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(FileSystemInfoPK pk, FileSystemInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                this.clearBean(ejb);
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                ejb.setDn(pk.getDn());
                ejb.setCn(new Integer((String)attrs.get("cn").get(0)));
                if (attrs.get("ccSnmpOID") != null) {
                    ejb.setSnmpOID((String)attrs.get("ccSnmpOID").get(0));
                }
                if (attrs.get("ccFileSystemMountPoint") != null) {
                    ejb.setFileSystemMountPoint((String)attrs.get("ccFileSystemMountPoint").get(0));
                }
                if (attrs.get("ccFileSystemType") != null) {
                    ejb.setFileSystemType((String)attrs.get("ccFileSystemType").get(0));
                }
                if (attrs.get("description") != null) {
                    ejb.setDescription((String)attrs.get("description").get(0));
                }
                String dn = ejb.getDn();
                dn = dn.replaceFirst("[^,]*,", "");
                dn = dn.replaceFirst(",[\\s\\w=]*", "");
                dn = dn.replaceFirst("ccFacilityId=", "");
                ejb.setFacilityId(dn);
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("load(): catch NamingException" + ex.getMessage()));
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"load() : LDAP query result is null");
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("load() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(FileSystemInfoBean ejb) throws EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(ejb.getDn());
                BasicAttributes addAttrs = new BasicAttributes();
                BasicAttributes replaceAttrs = new BasicAttributes();
                BasicAttributes removeAttrs = new BasicAttributes();
                if (attrs.get("description") == null && ejb.getDescription() != null) {
                    addAttrs.put("description", ejb.getDescription());
                } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                    removeAttrs.put("description", null);
                } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                    replaceAttrs.put("description", ejb.getDescription());
                }
                if (attrs.get("ccSnmpOID") == null && ejb.getSnmpOID() != null) {
                    addAttrs.put("ccSnmpOID", ejb.getSnmpOID());
                } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() == null) {
                    removeAttrs.put("ccSnmpOID", null);
                } else if (attrs.get("ccSnmpOID") != null && ejb.getSnmpOID() != null) {
                    replaceAttrs.put("ccSnmpOID", ejb.getSnmpOID());
                }
                if (attrs.get("ccFileSystemMountPoint") == null && ejb.getFileSystemMountPoint() != null) {
                    addAttrs.put("ccFileSystemMountPoint", ejb.getFileSystemMountPoint());
                } else if (attrs.get("ccFileSystemMountPoint") != null && ejb.getFileSystemMountPoint() == null) {
                    removeAttrs.put("ccFileSystemMountPoint", null);
                } else if (attrs.get("ccFileSystemMountPoint") != null && ejb.getFileSystemMountPoint() != null) {
                    replaceAttrs.put("ccFileSystemMountPoint", ejb.getFileSystemMountPoint());
                }
                if (attrs.get("ccFileSystemType") == null && ejb.getFileSystemType() != null) {
                    addAttrs.put("ccFileSystemType", ejb.getFileSystemType());
                } else if (attrs.get("ccFileSystemType") != null && ejb.getFileSystemType() == null) {
                    removeAttrs.put("ccFileSystemType", null);
                } else if (attrs.get("ccFileSystemType") != null && ejb.getFileSystemType() != null) {
                    replaceAttrs.put("ccFileSystemType", ejb.getFileSystemType());
                }
                ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
                ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
                ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"store() : LDAP query result is null");
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("store() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FileSystemInfoPK pk) throws RemoveException, EJBException {
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                ctx.destroySubcontext(pk.getDn());
                return;
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                AplLogger apllog = new AplLogger("REP", "rep");
                Object[] args = new String[]{pk.getDn()};
                apllog.put("SYS", "004", args);
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"remove() : LDAP query result is null");
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public FileSystemInfoPK create(FileSystemInfoBean ejb) throws CreateException, EJBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAll() throws FinderException {
        ArrayList<FileSystemInfoPK> ret = new ArrayList<FileSystemInfoPK>();
        m_log.debug((Object)"findAll()");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(BASE_DN, search.toString(), constraints);
                if (results == null) {
                    m_log.debug((Object)"findAll() : No Search Result");
                    ArrayList<FileSystemInfoPK> arrayList = ret;
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FileSystemInfoPK pk = new FileSystemInfoPK(aResult.getName() + "," + BASE_DN);
                    ret.add(pk);
                }
            }
            catch (NamingException e) {
                if (e instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findAll() : " + e.getMessage()));
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"findAll() : LDAP query result is null");
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findAll() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FileSystemInfoPK findByPrimaryKey(FileSystemInfoPK pk) throws FinderException {
        Context ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block20: {
                timer = null;
                m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    break block20;
                }
                catch (NamingException e) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e.getMessage()));
                }
                break block20;
                catch (NamingException ex) {
                    block21: {
                        if (ex instanceof CommunicationException) {
                            LdapConnectionManager.getConnectionManager().setDirContext(null);
                        }
                        m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
                        if (++retryCount < MAX_RETRY) break block21;
                        throw new EJBException((Exception)ex);
                    }
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e) {
                        m_log.error((Object)("findByPrimaryKey() context close failed : " + e.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    continue;
                }
                catch (NullPointerException e) {
                    block22: {
                        m_log.debug((Object)"findByFacilityIdAndName() : LDAP query result is null");
                        if (++retryCount < MAX_RETRY) break block22;
                        throw new EJBException((Exception)e);
                        {
                            catch (Throwable throwable) {
                                try {
                                    if (ctx != null) {
                                        ctx.close();
                                    }
                                }
                                catch (NamingException e2) {
                                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e2.getMessage()));
                                }
                                TimeKeeperService.stop(timer);
                                throw throwable;
                            }
                        }
                    }
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e3) {
                        m_log.error((Object)("findByPrimaryKey() context close failed : " + e3.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    continue;
                }
            }
            TimeKeeperService.stop((TimeKeeper)timer);
            return pk;
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        ArrayList<FileSystemInfoPK> ret = new ArrayList<FileSystemInfoPK>();
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(baseDn.toString(), search.toString(), constraints);
                if (results == null) {
                    m_log.warn((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
                    ArrayList<FileSystemInfoPK> arrayList = ret;
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FileSystemInfoPK pk = new FileSystemInfoPK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
            }
            catch (NamingException e) {
                if (e instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findByFacilityId() : " + e.getMessage()));
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"findByFacilityId() : LDAP query result is null");
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findByFacilityId() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemInfoPK findByFacilityIdAndName(String facilityId, String name) throws FinderException {
        m_log.debug((Object)("findByFacilityIdAndName() : FacilityId = " + facilityId + ", FacilityName = " + name));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer baseDn = new StringBuffer();
        baseDn.append("ccFacilityId");
        baseDn.append("=");
        baseDn.append(facilityId);
        baseDn.append(",");
        baseDn.append(BASE_DN);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FILE_SYSTEM_INFO);
        search.append(")(");
        search.append("cn");
        search.append("=");
        search.append(name);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        FileSystemInfoPK pk = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            block20: {
                TimeKeeper timer = null;
                try {
                    ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                    timer = TimeKeeperService.start();
                    results = ctx.search(baseDn.toString(), search.toString(), constraints);
                    if (results.hasMoreElements()) {
                        SearchResult aResult = (SearchResult)results.nextElement();
                        pk = new FileSystemInfoPK(aResult.getName() + "," + baseDn.toString());
                        break block20;
                    }
                    throw new FinderException("FacilityId = " + facilityId + ", FacilityName = " + name + " not found.");
                }
                catch (NamingException ex) {
                    if (ex instanceof CommunicationException) {
                        LdapConnectionManager.getConnectionManager().setDirContext(null);
                    }
                    m_log.debug((Object)("findByFacilityIdAndName() : " + ex.getMessage()));
                    if (++retryCount < MAX_RETRY) continue;
                    throw new EJBException((Exception)ex);
                }
                catch (NullPointerException e) {
                    m_log.debug((Object)"findByFacilityIdAndName() : LDAP query result is null");
                    if (++retryCount < MAX_RETRY) continue;
                    throw new EJBException((Exception)e);
                }
                finally {
                    try {
                        if (results != null) {
                            results.close();
                        }
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException e) {
                        m_log.error((Object)("findByFacilityIdAndName() context close failed : " + e.getMessage()));
                    }
                    TimeKeeperService.stop((TimeKeeper)timer);
                    continue;
                }
            }
            return pk;
        }
        return pk;
    }

    protected void clearBean(FileSystemInfoBean ejb) {
        ejb.setCn(null);
        ejb.setDescription(null);
        ejb.setFileSystemMountPoint(null);
        ejb.setFileSystemType(null);
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setSnmpOID(null);
    }
}

