/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class MultiPortVirtualServerSocket
extends ServerSocket {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$MultiPortVirtualServerSocket == null ? (class$org$jboss$remoting$transport$multiplex$MultiPortVirtualServerSocket = MultiPortVirtualServerSocket.class$("org.jboss.remoting.transport.multiplex.MultiPortVirtualServerSocket")) : class$org$jboss$remoting$transport$multiplex$MultiPortVirtualServerSocket));
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiPortVirtualServerSocket;

    public MultiPortVirtualServerSocket() throws IOException {
    }

    public MultiPortVirtualServerSocket(int port) throws IOException {
        super(port);
    }

    public MultiPortVirtualServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public MultiPortVirtualServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    public Socket accept() throws IOException {
        Protocol protocol;
        MultiplexingManager manager;
        SocketId clientPort;
        while (true) {
            Socket socket = super.accept();
            DataInputStream is = new DataInputStream(socket.getInputStream());
            clientPort = Protocol.acceptConnect(is);
            log.debug((Object)("accept(): clientPort:  " + clientPort.getPort()));
            manager = MultiplexingManager.getaManager(socket);
            protocol = manager.getProtocol();
            if (clientPort.getPort() >= 0) break;
            protocol.answerConnect(-2);
        }
        VirtualSocket virtualSocket = new VirtualSocket(manager, clientPort);
        int localPort = virtualSocket.getLocalVirtualPort();
        protocol.answerConnect(localPort);
        return virtualSocket;
    }

    public void close() throws IOException {
        log.info((Object)"MultiPortVirtualServerSocket: closing");
        super.close();
    }

    public String toString() {
        if (!this.isBound()) {
            return "MultiPortVirtualServerSocket[unbound]";
        }
        return "MultiPortVirtualServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

