/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDeployedObject;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEModule;
import org.jboss.management.j2ee.ServiceModuleMBean;

public class ServiceModule
extends J2EEModule
implements ServiceModuleMBean {
    private static final String[] eventTypes = new String[]{"j2ee.object.created", "j2ee.object.deleted"};
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$ServiceModule == null ? (class$org$jboss$management$j2ee$ServiceModule = ServiceModule.class$("org.jboss.management.j2ee.ServiceModule")) : class$org$jboss$management$j2ee$ServiceModule));
    private List mbeans = new ArrayList();
    static /* synthetic */ Class class$org$jboss$management$j2ee$ServiceModule;

    public static ObjectName create(MBeanServer mbeanServer, String moduleName, URL url) {
        String lDD = null;
        ObjectName jsr77Name = null;
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        lDD = url != null && url.getFile().endsWith(".xml") ? J2EEDeployedObject.getDeploymentDescriptor(url, null) : J2EEDeployedObject.getDeploymentDescriptor(url, 4);
        try {
            String[] jvms = (String[])mbeanServer.getAttribute(j2eeServerName, "javaVMs");
            ServiceModule serviceModule = new ServiceModule(moduleName, j2eeServerName, jvms, lDD);
            jsr77Name = serviceModule.getObjectName();
            mbeanServer.registerMBean(serviceModule, jsr77Name);
            log.debug((Object)("Created JSR-77 ServiceModule, name: " + moduleName));
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 ServiceModule: " + moduleName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, String pModuleName) {
        try {
            log.debug((Object)("destroy(), remove Service Module: " + pModuleName));
            if (pModuleName.indexOf("j2eeType=ServiceModule") >= 0) {
                J2EEManagedObject.removeObject(mbeanServer, pModuleName);
            } else {
                J2EEManagedObject.removeObject(mbeanServer, pModuleName, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "ServiceModule" + "," + "*");
            }
        }
        catch (InstanceNotFoundException infe) {
        }
        catch (Throwable e) {
            log.error((Object)("Could not destroy JSR-77 ServiceModule: " + pModuleName), e);
        }
    }

    public ServiceModule(String moduleName, ObjectName j2eeServerName, String[] jvmNames, String pDeploymentDescriptor) throws MalformedObjectNameException, InvalidParentException {
        super("ServiceModule", moduleName, j2eeServerName, jvmNames, pDeploymentDescriptor);
    }

    public String[] getMBeans() {
        return this.mbeans.toArray(new String[this.mbeans.size()]);
    }

    public String getMBean(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mbeans.size()) {
            return (String)this.mbeans.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("MBean".equals(lType)) {
            this.mbeans.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("MBean".equals(lType)) {
            this.mbeans.remove(pChild.getCanonicalName());
        }
    }

    public String[] getEventTypes() {
        return eventTypes;
    }

    public String getEventType(int index) {
        String type = null;
        if (index >= 0 && index < eventTypes.length) {
            type = eventTypes[index];
        }
        return type;
    }

    public void postCreation() {
        this.sendNotification("j2ee.object.created", "SAR module created");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "SAR module destroyed");
    }

    public String toString() {
        return "ServiceModule[ " + super.toString() + "MBeans: " + this.mbeans + " ]";
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>();
        Hashtable<String, String> lProperties = pParent.getKeyPropertyList();
        lReturn.put("J2EEServer", lProperties.get("name"));
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

