/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.tm.TransactionPropagationContextUtil;
import org.jboss.tm.TxManager;

public class TxPropagationInterceptor
implements Interceptor {
    private TransactionManager tm;

    public TxPropagationInterceptor(TransactionManager tm) {
        this.tm = tm;
    }

    public TxPropagationInterceptor() {
        this.tm = TxManager.getInstance();
    }

    public String getName() {
        return "TxPropagationInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object tpc = invocation.getMetaData((Object)ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, (Object)ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT);
        if (tpc != null) {
            Transaction tx = this.tm.getTransaction();
            if (tx != null) {
                throw new RuntimeException("cannot import a transaction context when a transaction is already associated with the thread");
            }
            Transaction importedTx = TransactionPropagationContextUtil.getTPCImporter().importTransactionPropagationContext(tpc);
            this.tm.resume(importedTx);
            try {
                Object object = invocation.invokeNext();
                return object;
            }
            finally {
                this.tm.suspend();
            }
        }
        return invocation.invokeNext();
    }
}

