/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployment.spi.JBossTarget;
import org.jboss.deployment.spi.SerializableTargetModuleID;
import org.jboss.deployment.spi.TargetModuleIDImpl;
import org.jboss.logging.Logger;

public class JMXTarget
implements JBossTarget {
    private static final Logger log = Logger.getLogger((Class)JMXTarget.class);
    private static final String DEFAULT_ADAPTOR_PATH = "/jmx/invoker/RMIAdaptor";
    private static final String JSR88_MBEAN = "jboss.management.local:type=JSR88DeploymentManager,name=DefaultManager";
    private static final String JSR88_MBEAN_OPT = "jsr88MBean";
    private URI deployURI;
    private Properties jndiEnv;
    private ObjectName jsr88MBean;

    public JMXTarget(URI deployURI) {
        log.debug((Object)("new JMXTarget: " + deployURI));
        try {
            if (new URI("http://org.jboss.deployment/default").equals(deployURI)) {
                StringBuffer uri = new StringBuffer("jnp://");
                uri.append(InetAddress.getLocalHost().getHostName());
                uri.append(":1099");
                uri.append(DEFAULT_ADAPTOR_PATH);
                deployURI = new URI(uri.toString());
            } else {
                String scheme = deployURI.getScheme();
                String host = deployURI.getHost();
                int port = deployURI.getPort();
                String path = deployURI.getPath();
                String query = deployURI.getRawQuery();
                StringBuffer uri = new StringBuffer(scheme + "://");
                uri.append(host != null ? host : InetAddress.getLocalHost().getHostName());
                uri.append(port > 0 ? ":" + port : "");
                uri.append(path != null && path.length() > 0 ? path : DEFAULT_ADAPTOR_PATH);
                uri.append(query != null ? "?" + query : "");
                deployURI = new URI(uri.toString());
            }
            log.debug((Object)("URI changed to: " + deployURI));
            this.deployURI = deployURI;
            this.parseQuery();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public String getDescription() {
        return "JBoss JMX deployment target";
    }

    public String getName() {
        return this.deployURI.toString();
    }

    public String getHostName() {
        return this.deployURI.getHost();
    }

    public void deploy(TargetModuleID targetModuleID) throws Exception {
        TargetModuleIDImpl moduleID = (TargetModuleIDImpl)targetModuleID;
        SerializableTargetModuleID smoduleID = new SerializableTargetModuleID(moduleID);
        MBeanServerConnection server = this.getMBeanServerConnection();
        String url = targetModuleID.getModuleID();
        Object[] args = new Object[]{smoduleID};
        String[] sig = new String[]{smoduleID.getClass().getName()};
        log.info((Object)("Begin deploy: " + url));
        server.invoke(this.jsr88MBean, "deploy", args, sig);
        log.info((Object)"End deploy");
    }

    public void start(TargetModuleID targetModuleID) throws Exception {
        MBeanServerConnection server = this.getMBeanServerConnection();
        URL url = new URL(targetModuleID.getModuleID());
        Object[] args = new Object[]{url};
        String[] sig = new String[]{URL.class.getName()};
        log.debug((Object)("Start: " + url));
        args = new Object[]{url.toExternalForm()};
        sig = new String[]{String.class.getName()};
        log.info((Object)("Begin start: " + url));
        server.invoke(this.jsr88MBean, "start", args, sig);
        log.info((Object)"End start");
    }

    public void stop(TargetModuleID targetModuleID) throws Exception {
        MBeanServerConnection server = this.getMBeanServerConnection();
        URL url = new URL(targetModuleID.getModuleID());
        Object[] args = new Object[]{url};
        String[] sig = new String[]{URL.class.getName()};
        log.debug((Object)("Stop: " + url));
        args = new Object[]{url.toExternalForm()};
        sig = new String[]{String.class.getName()};
        log.info((Object)("Begin stop: " + url));
        server.invoke(this.jsr88MBean, "stop", args, sig);
        log.info((Object)"End stop");
    }

    public void undeploy(TargetModuleID targetModuleID) throws Exception {
        MBeanServerConnection server = this.getMBeanServerConnection();
        String url = targetModuleID.getModuleID();
        Object[] args = new Object[]{url};
        String[] sig = new String[]{String.class.getName()};
        log.info((Object)("Begin undeploy: " + url));
        server.invoke(this.jsr88MBean, "undeploy", args, sig);
        log.info((Object)"End undeploy");
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType) throws TargetException {
        try {
            ArrayList<TargetModuleIDImpl> list = new ArrayList<TargetModuleIDImpl>();
            MBeanServerConnection server = this.getMBeanServerConnection();
            Object[] args = new Object[]{new Integer(moduleType.getValue())};
            String[] sig = new String[]{Integer.TYPE.getName()};
            SerializableTargetModuleID[] modules = (SerializableTargetModuleID[])server.invoke(this.jsr88MBean, "getAvailableModules", args, sig);
            for (int n = 0; n < modules.length; ++n) {
                SerializableTargetModuleID id = modules[n];
                String moduleID = id.getModuleID();
                boolean isRunning = id.isRunning();
                ModuleType type = ModuleType.getModuleType((int)id.getModuleType());
                TargetModuleIDImpl tmid = new TargetModuleIDImpl(this, moduleID, null, isRunning, type);
                this.convertChildren(tmid, id);
                list.add(tmid);
            }
            TargetModuleID[] targetModuleIDs = new TargetModuleID[list.size()];
            list.toArray(targetModuleIDs);
            return targetModuleIDs;
        }
        catch (Exception e) {
            log.error((Object)"Cannot get available modules", (Throwable)e);
            TargetException tex = new TargetException("");
            tex.initCause((Throwable)e);
            throw tex;
        }
    }

    private void convertChildren(TargetModuleIDImpl parent, SerializableTargetModuleID parentID) {
        SerializableTargetModuleID[] children = parentID.getChildModuleIDs();
        int length = children != null ? children.length : 0;
        for (int n = 0; n < length; ++n) {
            SerializableTargetModuleID id = children[n];
            String moduleID = id.getModuleID();
            boolean isRunning = id.isRunning();
            ModuleType type = ModuleType.getModuleType((int)id.getModuleType());
            TargetModuleIDImpl child = new TargetModuleIDImpl(this, moduleID, parent, isRunning, type);
            parent.addChildTargetModuleID(child);
            this.convertChildren(child, id);
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws NamingException {
        Properties env = this.buildJNDIEnv();
        String lookupPath = this.deployURI.getPath();
        log.debug((Object)("JNDI lookup: " + lookupPath));
        log.trace((Object)("Creating InitialContext with env: " + env));
        InitialContext ctx = new InitialContext(env);
        MBeanServerConnection server = (MBeanServerConnection)ctx.lookup(lookupPath);
        return server;
    }

    private void parseQuery() throws Exception {
        String query = this.deployURI.getRawQuery();
        log.debug((Object)("DeployURI.rawQuery: " + query));
        Properties params = new Properties();
        if (query != null) {
            String[] options = query.split("[&=]");
            for (int n = 0; n < options.length; n += 2) {
                String name = URLDecoder.decode(options[n], "UTF-8");
                String value = URLDecoder.decode(options[n + 1], "UTF-8");
                params.setProperty(name, value);
            }
        }
        String name = params.getProperty(JSR88_MBEAN_OPT, JSR88_MBEAN);
        this.jsr88MBean = new ObjectName(name);
    }

    private Properties buildJNDIEnv() {
        if (this.jndiEnv == null) {
            this.jndiEnv = new Properties();
            String query = this.deployURI.getQuery();
            if (query != null) {
                log.debug((Object)("Parsing query string: " + query));
                StringTokenizer tokenizer = new StringTokenizer(query, "=&");
                while (tokenizer.hasMoreTokens()) {
                    String name = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    this.jndiEnv.setProperty(name, value);
                }
            }
            if (this.jndiEnv.getProperty("java.naming.factory.initial") == null) {
                this.jndiEnv.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            }
            if (this.jndiEnv.getProperty("java.naming.provider.url") == null) {
                int port;
                String host = this.deployURI.getHost();
                if (host == null) {
                    try {
                        host = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        host = "localhost";
                    }
                }
                if ((port = this.deployURI.getPort()) <= 0) {
                    port = 1099;
                }
                String jnpURL = "jnp://" + host + ':' + port;
                this.jndiEnv.setProperty("java.naming.provider.url", jnpURL);
            }
            if (this.jndiEnv.getProperty("java.naming.factory.object") == null) {
                this.jndiEnv.setProperty("java.naming.factory.object", "org.jboss.naming");
            }
        }
        return this.jndiEnv;
    }
}

