/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.services.DeploymentManagerServiceMBean;
import org.jboss.deployment.spi.SerializableTargetModuleID;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.file.Files;

public class DeploymentManagerService
extends ServiceMBeanSupport
implements DeploymentManagerServiceMBean {
    private Map moduleMap = Collections.synchronizedMap(new HashMap());
    private ObjectName mainDeployer;
    private ObjectName carDeployer;
    private ObjectName earDeployer;
    private ObjectName ejbDeployer;
    private ObjectName rarDeployer;
    private ObjectName warDeployer;
    File uploadDir;

    public ObjectName getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(ObjectName mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public ObjectName getEARDeployer() {
        return this.earDeployer;
    }

    public void setEARDeployer(ObjectName name) {
        this.earDeployer = name;
    }

    public ObjectName getEJBDeployer() {
        return this.ejbDeployer;
    }

    public void setEJBDeployer(ObjectName name) {
        this.ejbDeployer = name;
    }

    public ObjectName getRARDeployer() {
        return this.rarDeployer;
    }

    public void setRARDeployer(ObjectName name) {
        this.rarDeployer = name;
    }

    public ObjectName getWARDeployer() {
        return this.warDeployer;
    }

    public void setWARDeployer(ObjectName name) {
        this.warDeployer = name;
    }

    public ObjectName getCARDeployer() {
        return this.carDeployer;
    }

    public void setCARDeployer(ObjectName name) {
        this.carDeployer = name;
    }

    public File getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(File uploadDir) {
        this.uploadDir = uploadDir;
    }

    public Map getModuleMap() {
        return Collections.unmodifiableMap(this.moduleMap);
    }

    public void deploy(SerializableTargetModuleID moduleID) throws Exception {
        String url = moduleID.getModuleID();
        URL deployURL = new URL(url);
        URLConnection conn = deployURL.openConnection();
        int contentLength = conn.getContentLength();
        this.log.debug((Object)("Begin deploy, url: " + deployURL + ", contentLength: " + contentLength));
        File path = new File(deployURL.getFile());
        String archive = path.getName();
        File deployFile = new File(this.uploadDir, archive);
        if (deployFile.exists()) {
            throw new IOException("deployURL(" + deployURL + ") collides with: " + deployFile.getPath());
        }
        File parentFile = deployFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Failed to create local path: " + parentFile);
        }
        InputStream is = conn.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buffer = new byte[4096];
        FileOutputStream fos = new FileOutputStream(deployFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        int count = 0;
        while ((count = bis.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bis.close();
        bos.close();
        this.moduleMap.put(url, moduleID);
    }

    public void start(String url) throws Exception {
        SerializableTargetModuleID moduleID = (SerializableTargetModuleID)this.moduleMap.get(url);
        if (moduleID == null) {
            throw new IOException("deployURL(" + url + ") has not been distributed");
        }
        URL deployURL = new URL(url);
        File path = new File(deployURL.getFile());
        String archive = path.getName();
        File deployFile = new File(this.uploadDir, archive);
        if (!deployFile.exists()) {
            throw new IOException("deployURL(" + url + ") has no local archive");
        }
        MainDeployerMBean proxy = (MainDeployerMBean)MBeanServerInvocationHandler.newProxyInstance(this.server, this.mainDeployer, MainDeployerMBean.class, false);
        proxy.deploy(deployFile.toURL());
        moduleID.setRunning(true);
        moduleID.clearChildModuleIDs();
        DeploymentInfo info = proxy.getDeployment(deployFile.toURL());
        this.fillChildrenTargetModuleID(moduleID, info);
    }

    public void stop(String url) throws Exception {
        SerializableTargetModuleID moduleID = (SerializableTargetModuleID)this.moduleMap.get(url);
        if (moduleID == null) {
            throw new IOException("deployURL(" + url + ") has not been distributed");
        }
        URL deployURL = new URL(url);
        File path = new File(deployURL.getFile());
        String archive = path.getName();
        File deployFile = new File(this.uploadDir, archive);
        if (!deployFile.exists()) {
            throw new IOException("deployURL(" + url + ") has no local archive");
        }
        MainDeployerMBean proxy = (MainDeployerMBean)MBeanServerInvocationHandler.newProxyInstance(this.server, this.mainDeployer, MainDeployerMBean.class, false);
        proxy.undeploy(deployFile.toURL());
        moduleID.setRunning(false);
    }

    public void undeploy(String url) throws Exception {
        URL deployURL;
        File path;
        String archive;
        File deployFile;
        SerializableTargetModuleID moduleID = (SerializableTargetModuleID)this.moduleMap.get(url);
        if (moduleID == null) {
            return;
        }
        if (moduleID.isRunning()) {
            this.stop(url);
        }
        if (!(deployFile = new File(this.uploadDir, archive = (path = new File((deployURL = new URL(url)).getFile())).getName())).exists()) {
            throw new IOException("deployURL(" + url + ") has not been distributed");
        }
        Files.delete((File)deployFile);
        this.moduleMap.remove(url);
    }

    public SerializableTargetModuleID[] getAvailableModules(int moduleType) throws TargetException {
        ArrayList<SerializableTargetModuleID> matches = new ArrayList<SerializableTargetModuleID>();
        Iterator modules = this.moduleMap.values().iterator();
        while (modules.hasNext()) {
            SerializableTargetModuleID module = (SerializableTargetModuleID)modules.next();
            if (module.getModuleType() != moduleType) continue;
            matches.add(module);
        }
        SerializableTargetModuleID[] ids = new SerializableTargetModuleID[matches.size()];
        matches.toArray(ids);
        return ids;
    }

    private void fillChildrenTargetModuleID(SerializableTargetModuleID moduleID, DeploymentInfo info) {
        Iterator it = info.subDeployments.iterator();
        while (it.hasNext()) {
            DeploymentInfo sdi = (DeploymentInfo)it.next();
            try {
                ModuleType type = this.getModuleType(sdi);
                if (type == null) continue;
                String module = sdi.url.toString();
                boolean isRunning = DeploymentState.STARTED == sdi.state;
                SerializableTargetModuleID child = new SerializableTargetModuleID(moduleID, module, type.getValue(), isRunning);
                moduleID.addChildTargetModuleID(child);
                this.fillChildrenTargetModuleID(child, sdi);
            }
            catch (UnsupportedOperationException e) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)"Ignoring", (Throwable)e);
            }
        }
    }

    private ModuleType getModuleType(DeploymentInfo info) {
        if (info.deployer == null) {
            return null;
        }
        ModuleType type = null;
        ObjectName deployer = info.deployer.getServiceName();
        if (deployer.equals(this.carDeployer)) {
            type = ModuleType.CAR;
        } else if (deployer.equals(this.ejbDeployer)) {
            type = ModuleType.EJB;
        } else if (deployer.equals(this.earDeployer)) {
            type = ModuleType.EAR;
        } else if (deployer.equals(this.rarDeployer)) {
            type = ModuleType.RAR;
        } else if (deployer.equals(this.warDeployer)) {
            type = ModuleType.WAR;
        }
        return type;
    }
}

