/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.net.URL;
import javax.management.Attribute;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.services.binding.ServiceBindingManagerMBean;
import org.jboss.services.binding.ServiceConfig;
import org.jboss.services.binding.ServicesConfigDelegate;
import org.jboss.services.binding.ServicesStore;
import org.jboss.services.binding.ServicesStoreFactory;
import org.jboss.system.ServiceBinding;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfigLocator;

public class ServiceBindingManager
implements MBeanRegistration,
ServiceBindingManagerMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$services$binding$ServiceBindingManager == null ? (class$org$jboss$services$binding$ServiceBindingManager = ServiceBindingManager.class$("org.jboss.services.binding.ServiceBindingManager")) : class$org$jboss$services$binding$ServiceBindingManager));
    private MBeanServer server;
    private ObjectName serviceName;
    private String serverName;
    private String storeFactoryClassName = "org.jboss.services.binding.XMLServicesStoreFactory";
    private ObjectName serviceController;
    private ServicesStore store;
    private URL storeURL;
    static /* synthetic */ Class class$org$jboss$services$binding$ServiceBindingManager;
    static /* synthetic */ Class class$org$jboss$system$ServiceBinding;

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getStoreFactoryClassName() {
        return this.storeFactoryClassName;
    }

    public void setStoreFactoryClassName(String storeFactoryClassName) {
        this.storeFactoryClassName = storeFactoryClassName;
    }

    public URL getStoreURL() {
        return this.storeURL;
    }

    public void setStoreURL(URL storeURL) {
        this.storeURL = storeURL;
    }

    public ObjectName getServiceController() {
        return this.serviceController;
    }

    public void setServiceController(ObjectName serviceController) throws Exception {
        this.serviceController = serviceController;
        this.registerProxy();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            try {
                this.setServiceController(ServiceControllerMBean.OBJECT_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void preDeregister() throws Exception {
        this.unregisterProxy();
        if (this.store != null) {
            this.store.store(this.storeURL);
        }
    }

    public void postDeregister() {
    }

    public ServiceConfig getServiceConfig(ObjectName serviceName) throws Exception {
        log.debug((Object)("getServiceConfig, server:" + this.serverName + ", serviceName:" + serviceName));
        if (this.store == null) {
            this.initStore();
        }
        ServiceConfig svcConfig = this.store.getService(this.serverName, serviceName);
        ServiceConfig configCopy = null;
        if (svcConfig != null) {
            configCopy = (ServiceConfig)svcConfig.clone();
        }
        return configCopy;
    }

    public void applyServiceConfig(ObjectName serviceName) throws Exception {
        ServiceConfig svcConfig;
        if (this.store == null) {
            this.initStore();
        }
        if ((svcConfig = this.store.getService(this.serverName, serviceName)) != null) {
            log.debug((Object)("applyServiceConfig, server:" + this.serverName + ", serviceName:" + serviceName + ", config=" + svcConfig));
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            String delegateName = svcConfig.getServiceConfigDelegateClassName();
            if (delegateName != null) {
                Class<?> delegateClass = loader.loadClass(delegateName);
                ServicesConfigDelegate delegate = (ServicesConfigDelegate)delegateClass.newInstance();
                delegate.applyConfig(svcConfig, this.server);
            }
        }
    }

    private void registerProxy() throws Exception {
        if (this.serviceController != null) {
            log.debug((Object)("Registering with ServiceController: " + this.serviceController));
            ServiceBinding proxy = (ServiceBinding)MBeanProxyExt.create((Class)(class$org$jboss$system$ServiceBinding == null ? (class$org$jboss$system$ServiceBinding = ServiceBindingManager.class$("org.jboss.system.ServiceBinding")) : class$org$jboss$system$ServiceBinding), (ObjectName)this.serviceName, (MBeanServer)this.server);
            try {
                this.server.setAttribute(this.serviceController, new Attribute("ServiceBinding", proxy));
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                log.debug((Object)("Failed to register with ServiceController: " + this.serviceController + ", reason: " + t.getMessage()));
                throw (Exception)t;
            }
        }
    }

    private void unregisterProxy() {
        if (this.serviceController != null) {
            log.debug((Object)("Unregistering with ServiceController: " + this.serviceController));
            try {
                this.server.setAttribute(this.serviceController, new Attribute("ServiceBinding", null));
            }
            catch (Exception e) {
                Throwable t = JMXExceptionDecoder.decode((Throwable)e);
                log.debug((Object)("Failed to unregister with ServiceController: " + this.serviceController + ", reason: " + t.getMessage()));
            }
        }
    }

    private void initStore() throws Exception {
        log.info((Object)"Initializing store");
        if (this.storeURL == null) {
            this.storeURL = ServerConfigLocator.locate().getServerConfigURL();
        }
        log.info((Object)("Using StoreURL: " + this.storeURL));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> factoryClass = loader.loadClass(this.storeFactoryClassName);
        ServicesStoreFactory storeFactory = (ServicesStoreFactory)factoryClass.newInstance();
        this.store = storeFactory.newInstance();
        this.store.load(this.storeURL);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

