/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.failover.monitor.jmx;

import com.clustercontrol.failover.monitor.jmx.FailoverMonitor;
import com.clustercontrol.failover.monitor.jmx.FailoverMonitorServiceMBean;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

public class FailoverMonitorService
extends ServiceMBeanSupport
implements FailoverMonitorServiceMBean,
HAPartition.AsynchHAMembershipListener {
    private String jndiName = "FailoverMonitorService";
    private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    private static final String OBJECT_NAME = "jboss:service=";
    private static final String OPERATION_NAME = "getCurrentView";
    private String partitionName = "HinemosPartition";
    private HAPartition partition;
    private String hostname;
    private ArrayList<String> members = new ArrayList();

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String name) {
        this.partitionName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.log.info((Object)("setJndiName() : jndiName = " + jndiName));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            NamingException ne;
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
        }
    }

    public String getName() {
        return "FailoverMonitorService(" + this.jndiName + ")";
    }

    public void startService() throws NamingException {
        this.log.info((Object)("Start FailoverMonitorService(" + this.jndiName + ")"));
        InitialContext ctx = new InitialContext();
        String partitionJndiName = "/HAPartition/" + this.partitionName;
        this.partition = (HAPartition)ctx.lookup(partitionJndiName);
        this.partition.registerMembershipListener((HAPartition.HAMembershipListener)this);
        this.log.info((Object)"Registered as MembershipListener");
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            this.log.warn((Object)"Failed to lookup local hostname", (Throwable)e);
            this.hostname = "<unknown>";
        }
        this.getAllMembers();
        this.rebind();
        this.log.info((Object)("Started FailoverMonitorService(" + this.jndiName + ")"));
    }

    public void stopService() throws NamingException {
        this.log.info((Object)("Stop FailoverMonitorService(" + this.jndiName + ")"));
        this.partition.unregisterMembershipListener((HAPartition.HAMembershipListener)this);
        this.unbind(this.jndiName);
        this.log.info((Object)("Stoped FailoverMonitorService(" + this.jndiName + ")"));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws NamingException {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = FailoverMonitorService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }

    public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        FailoverMonitor monitor = new FailoverMonitor();
        if (monitor.getAllMembers().size() == 0) {
            monitor.setAllMembers(this.members);
        }
        monitor.monitor(deadMembers, newMembers, allMembers);
    }

    private void getAllMembers() {
        this.log.debug((Object)"getAllMembers() start :");
        try {
            this.members.clear();
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME + this.partitionName);
            Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
            if (returnObject instanceof Vector) {
                Vector returnVector = (Vector)returnObject;
                for (int i = 0; i < returnVector.size(); ++i) {
                    String work = (String)returnVector.get(i);
                    String[] node = work.split(":");
                    this.members.add(node[0]);
                }
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (IOException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        this.log.debug((Object)"getAllMembers() end :");
    }
}

