/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmppoller;

import com.clustercontrol.sharedtable.bean.DataTable;
import com.clustercontrol.sharedtable.bean.ValueObject;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpVarBind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpPoller
implements SnmpHandler {
    protected static Log m_log = LogFactory.getLog(SnmpPoller.class);
    private String m_ipAddress;
    private String[] m_oidText;
    private ArrayList<SnmpObjectId> m_startOids;
    private ArrayList<SnmpObjectId> m_stopOids;
    private DataTable m_dataTable;
    private String m_message = null;
    private boolean m_waitFlg;
    private boolean m_indexCheckFlg = false;
    private int m_indexCheckDiffIndexRetryCount = 0;
    private int m_indexCheckVarBindSizeRetryCount = 0;
    private int m_indexCheckRetryCountTotal = 0;
    private final int MAX_RETRY_COUNT = 10;
    private int m_indexCheckLastIndexRetryCount = 0;
    private ArrayList<String> m_lastPollingOids;
    private boolean m_retryFlg = false;
    private final int m_retryCount = 1;
    private int m_errorCode = 0;
    private final int Normal = 0;
    private final int TimeOutError = 1;
    private final int InternalError = 2;

    private void init() {
        this.m_indexCheckDiffIndexRetryCount = 0;
        this.m_indexCheckVarBindSizeRetryCount = 0;
        this.m_indexCheckRetryCountTotal = 0;
        this.m_indexCheckLastIndexRetryCount = 0;
        this.m_errorCode = 0;
        this.m_message = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void polling(InetAddress ipAddress, int port, int version, String community, int retries, int timeout, List<String> oidList, boolean indexCheckFlg, DataTable table) {
        this.init();
        this.m_dataTable = table;
        this.m_ipAddress = ipAddress.toString();
        this.m_indexCheckFlg = indexCheckFlg;
        SnmpPeer peer = new SnmpPeer(ipAddress);
        if (port != -1) {
            peer.setPort(port);
        }
        if (timeout != -1) {
            peer.setTimeout(timeout);
        }
        if (retries != -1) {
            peer.setRetries(retries);
        }
        SnmpParameters parms = peer.getParameters();
        parms.setVersion(version);
        if (community != null) {
            parms.setReadCommunity(community);
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("polling() start :" + ipAddress.toString()));
            m_log.debug((Object)("Port            : " + peer.getPort()));
            m_log.debug((Object)("Version         : " + peer.getParameters().getVersion()));
            m_log.debug((Object)("Community       : " + peer.getParameters().getReadCommunity()));
            m_log.debug((Object)("Retries         : " + peer.getRetries()));
            m_log.debug((Object)("Timeout         : " + peer.getTimeout()));
            m_log.debug((Object)("IndexCheckFlg   : " + indexCheckFlg));
        }
        SnmpSession session = null;
        try {
            session = new SnmpSession(peer);
        }
        catch (SocketException e) {
            m_log.error((Object)("polling() warning  :" + ipAddress.toString() + " SocketException creating the SNMP session"));
            this.m_errorCode = 2;
            return;
        }
        session.setDefaultHandler((SnmpHandler)this);
        try {
            this.m_oidText = new String[oidList.size()];
            this.m_startOids = new ArrayList(oidList.size());
            this.m_stopOids = new ArrayList(oidList.size());
            this.m_lastPollingOids = new ArrayList(oidList.size());
            int i = 0;
            SnmpPduRequest pdu = new SnmpPduRequest(161);
            pdu.setRequestId(SnmpPduPacket.nextSequence());
            Iterator<String> itr = oidList.iterator();
            while (itr.hasNext()) {
                this.m_oidText[i] = itr.next();
                if (this.m_oidText[i].endsWith(".0")) {
                    this.m_oidText[i] = this.m_oidText[i].substring(0, this.m_oidText[i].lastIndexOf(".0"));
                }
                SnmpObjectId startOid = new SnmpObjectId(this.m_oidText[i]);
                SnmpObjectId stopOid = new SnmpObjectId(this.m_oidText[i]);
                int[] ids = stopOid.getIdentifiers();
                int n = ids.length - 1;
                ids[n] = ids[n] + 1;
                stopOid.setIdentifiers(ids);
                SnmpObjectId oId = new SnmpObjectId(this.m_oidText[i]);
                pdu.addVarBind(new SnmpVarBind(oId));
                this.m_startOids.add(startOid);
                this.m_stopOids.add(stopOid);
                this.m_lastPollingOids.add(this.m_oidText[i]);
                ++i;
            }
            for (int count = 0; count < 2; ++count) {
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_waitFlg = true;
                    session.send((SnmpPduPacket)pdu);
                    m_log.debug((Object)("polling() : " + this.m_ipAddress + " send SnmpPduRequest"));
                    if (this.m_waitFlg) {
                        session.wait();
                    }
                }
                if (!this.m_retryFlg) {
                    break;
                }
                this.m_dataTable.clear();
            }
        }
        catch (InterruptedException e) {
            m_log.error((Object)("polling() warning :" + ipAddress.toString() + " polling failed at InterruptedException"));
            this.m_errorCode = 2;
            return;
        }
        finally {
            try {
                session.close();
            }
            catch (Exception e) {
                m_log.warn((Object)("polling():" + this.m_ipAddress + " Session close failed"));
            }
        }
        if (this.m_errorCode == 1 || this.m_errorCode == 2) {
            // empty if block
        }
        if (this.m_indexCheckRetryCountTotal >= 100) {
            m_log.warn((Object)("polling():" + this.m_ipAddress + " too many retries. count : " + this.m_indexCheckRetryCountTotal));
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("polling() " + this.m_ipAddress + " retry total count : " + this.m_indexCheckRetryCountTotal));
            m_log.debug((Object)("polling() end :" + ipAddress.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
        try {
            long time = System.currentTimeMillis();
            SnmpPduRequest req = null;
            if (!(pdu instanceof SnmpPduRequest)) {
                m_log.error((Object)("polling() error :" + session.toString() + " Received non-request pdu"));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    session.notify();
                }
                return;
            }
            req = (SnmpPduRequest)pdu;
            if (pdu.getCommand() != 162) {
                m_log.error((Object)("polling() error :" + session.toString() + "  Received non-response command " + pdu.getCommand()));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    session.notify();
                }
                return;
            }
            if (req.getErrorStatus() != 0) {
                m_log.error((Object)("polling() error :" + session.toString() + "  Error Status " + req.getErrorStatus()));
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    this.m_errorCode = 2;
                    session.notify();
                }
                return;
            }
            SnmpPduRequest nxt = new SnmpPduRequest(161);
            nxt.setRequestId(SnmpPduPacket.nextSequence());
            String lastIndexStr = null;
            int maxIndex = -1;
            ArrayList<SnmpObjectId> nextStartOids = new ArrayList<SnmpObjectId>(this.m_startOids.size());
            ArrayList<SnmpObjectId> nextStopOids = new ArrayList<SnmpObjectId>(this.m_stopOids.size());
            ArrayList<Object> lastPollingOids = new ArrayList(this.m_startOids.size());
            ArrayList<ValueObject> entryBuffer = new ArrayList<ValueObject>(this.m_startOids.size());
            int length = pdu.getLength();
            for (int i = 0; i < length; ++i) {
                SnmpVarBind var = pdu.getVarBindAt(i);
                if (var.getValue().typeId() == -126 || this.m_stopOids.get(i) != null && this.m_stopOids.get(i).compare(var.getName()) < 0) {
                    if (!m_log.isDebugEnabled()) continue;
                    m_log.debug((Object)(this.m_ipAddress + " stop polling. " + i + ", " + this.m_startOids.get(i) + ", " + this.m_stopOids.get(i) + " - " + var.getName()));
                    continue;
                }
                String oidString = var.getName().toString();
                if (m_log.isDebugEnabled()) {
                    m_log.debug((Object)("get " + this.m_ipAddress + " " + oidString + " " + time + " " + var.getValue().getClass().getName() + " " + var.getValue().toString()));
                }
                if (!this.m_startOids.get(i).isRootOf(var.getName())) {
                    if (!m_log.isDebugEnabled()) continue;
                    m_log.debug((Object)(this.m_ipAddress + " stop polling.. " + i + ", " + this.m_startOids.get(i) + ", " + this.m_stopOids.get(i) + " - " + var.getName()));
                    continue;
                }
                if (this.m_indexCheckFlg) {
                    if (lastIndexStr == null) {
                        lastIndexStr = oidString.substring(oidString.lastIndexOf(".") + 1);
                    } else {
                        String indexStr = oidString.substring(oidString.lastIndexOf(".") + 1);
                        if (!lastIndexStr.equals(indexStr)) {
                            m_log.debug((Object)("Index not match. " + this.m_ipAddress + ", " + lastIndexStr + ", " + oidString));
                            int lastIndex = Integer.parseInt(lastIndexStr);
                            if (lastIndex > maxIndex) {
                                maxIndex = lastIndex;
                            }
                        }
                        lastIndexStr = indexStr;
                    }
                }
                if (m_log.isDebugEnabled()) {
                    m_log.debug((Object)("set " + this.m_ipAddress + "," + oidString + "," + time + "," + var.getValue().toString() + ", " + var.getValue()));
                }
                if (var.getValue() instanceof SnmpTimeTicks) {
                    long value = ((SnmpUInt32)var.getValue()).getValue();
                    if (this.m_indexCheckFlg) {
                        entryBuffer.add(new ValueObject(oidString, time, String.valueOf(value)));
                        m_log.debug((Object)("snmpReceivedPdu() dataTable put : entryKey : " + oidString + ", time : " + time + ", longValue : " + String.valueOf(value)));
                    } else {
                        this.m_dataTable.putValue(oidString, time, String.valueOf(value));
                        m_log.debug((Object)("snmpReceivedPdu() dataTable put : entryKey : " + oidString + ", time : " + time + ", longValue : " + String.valueOf(value)));
                    }
                } else if (this.m_indexCheckFlg) {
                    entryBuffer.add(new ValueObject(oidString, time, var.getValue().toString()));
                    m_log.debug((Object)("snmpReceivedPdu() dataTable put : entryKey : " + oidString + ", time : " + time + ", longValue : " + var.getValue().toString()));
                } else {
                    this.m_dataTable.putValue(oidString, time, var.getValue().toString());
                    m_log.debug((Object)("snmpReceivedPdu() dataTable put : entryKey : " + oidString + ", time : " + time + ", longValue : " + var.getValue().toString()));
                }
                nextStartOids.add(this.m_startOids.get(i));
                nextStopOids.add(this.m_stopOids.get(i));
                nxt.addVarBind(new SnmpVarBind(var.getName()));
                lastPollingOids.add(var.getName().toString());
            }
            if (this.m_indexCheckFlg) {
                if (maxIndex == -1 && (lastPollingOids.size() == this.m_lastPollingOids.size() || lastPollingOids.size() == 0)) {
                    for (ValueObject entry : entryBuffer) {
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)("set (buffer to table) " + this.m_ipAddress + "," + entry.getKey() + "," + time + "," + entry.getValue().toString() + ", " + entry.getValue()));
                        }
                        this.m_dataTable.putValue(entry);
                    }
                    this.m_indexCheckDiffIndexRetryCount = 0;
                    this.m_indexCheckVarBindSizeRetryCount = 0;
                } else {
                    m_log.debug((Object)("detect error. " + this.m_ipAddress));
                }
                if (lastPollingOids.size() == 0) {
                    this.m_indexCheckDiffIndexRetryCount = 0;
                    this.m_indexCheckVarBindSizeRetryCount = 0;
                    if (this.m_indexCheckLastIndexRetryCount < 1) {
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)("check retry. count=" + this.m_indexCheckLastIndexRetryCount + " " + this.m_ipAddress));
                        }
                        nextStartOids.clear();
                        nextStopOids.clear();
                        lastPollingOids.clear();
                        nxt = new SnmpPduRequest(161);
                        nxt.setRequestId(SnmpPduPacket.nextSequence());
                        for (int i = 0; i < this.m_lastPollingOids.size(); ++i) {
                            if (m_log.isDebugEnabled()) {
                                m_log.debug((Object)("retry last polling set VarBind " + this.m_ipAddress + "," + this.m_lastPollingOids.get(i)));
                            }
                            nextStartOids.add(this.m_startOids.get(i));
                            nextStopOids.add(this.m_stopOids.get(i));
                            nxt.addVarBind(new SnmpVarBind(this.m_lastPollingOids.get(i)));
                            lastPollingOids = this.m_lastPollingOids;
                        }
                        ++this.m_indexCheckLastIndexRetryCount;
                        ++this.m_indexCheckRetryCountTotal;
                    }
                } else {
                    if (m_log.isDebugEnabled() && this.m_indexCheckLastIndexRetryCount != 0) {
                        m_log.debug((Object)("detect error." + this.m_ipAddress));
                    }
                    this.m_indexCheckLastIndexRetryCount = 0;
                    if (maxIndex >= 0) {
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)("recovery(index not match) " + this.m_ipAddress + "  max index:" + maxIndex + "  next VarBind size:" + lastPollingOids.size()));
                        }
                        nextStartOids.clear();
                        nextStopOids.clear();
                        lastPollingOids.clear();
                        nxt = new SnmpPduRequest(161);
                        nxt.setRequestId(SnmpPduPacket.nextSequence());
                        if (this.m_indexCheckDiffIndexRetryCount < 10) {
                            for (int i = 0; i < this.m_lastPollingOids.size(); ++i) {
                                String lastOid = this.m_lastPollingOids.get(i);
                                String nextOid = lastOid.substring(0, lastOid.lastIndexOf(".") + 1) + (maxIndex - 1);
                                nextStartOids.add(this.m_startOids.get(i));
                                nextStopOids.add(this.m_stopOids.get(i));
                                nxt.addVarBind(new SnmpVarBind(nextOid));
                                lastPollingOids.add(nextOid);
                                if (!m_log.isDebugEnabled()) continue;
                                m_log.debug((Object)("set VarBind " + this.m_ipAddress + "," + nextOid));
                            }
                        } else {
                            m_log.error((Object)("too many retries(index not match). " + this.m_ipAddress + " count:" + this.m_indexCheckDiffIndexRetryCount));
                            this.m_dataTable.clear();
                        }
                        ++this.m_indexCheckDiffIndexRetryCount;
                        this.m_indexCheckVarBindSizeRetryCount = 0;
                        ++this.m_indexCheckRetryCountTotal;
                    } else if (lastPollingOids.size() != this.m_lastPollingOids.size()) {
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)("recovery(next count:" + lastPollingOids.size() + ") " + this.m_ipAddress));
                        }
                        nextStartOids.clear();
                        nextStopOids.clear();
                        lastPollingOids.clear();
                        nxt = new SnmpPduRequest(161);
                        nxt.setRequestId(SnmpPduPacket.nextSequence());
                        if (this.m_indexCheckVarBindSizeRetryCount < 10) {
                            for (int i = 0; i < this.m_lastPollingOids.size(); ++i) {
                                String nextOid = this.m_lastPollingOids.get(i);
                                nextStartOids.add(this.m_startOids.get(i));
                                nextStopOids.add(this.m_stopOids.get(i));
                                nxt.addVarBind(new SnmpVarBind(nextOid));
                                lastPollingOids.add(nextOid);
                                if (!m_log.isDebugEnabled()) continue;
                                m_log.debug((Object)("set VarBind " + this.m_ipAddress + "," + nextOid));
                            }
                        } else {
                            m_log.error((Object)("too many retries(VarBind size not match). " + this.m_ipAddress + " count:" + this.m_indexCheckVarBindSizeRetryCount));
                            this.m_dataTable.clear();
                        }
                        this.m_indexCheckDiffIndexRetryCount = 0;
                        ++this.m_indexCheckVarBindSizeRetryCount;
                        ++this.m_indexCheckRetryCountTotal;
                    }
                }
            }
            if (nxt.getLength() == 0) {
                SnmpSession snmpSession = session;
                synchronized (snmpSession) {
                    session.notify();
                }
                return;
            }
            this.m_startOids = nextStartOids;
            this.m_stopOids = nextStopOids;
            this.m_lastPollingOids = lastPollingOids;
            session.send((SnmpPduPacket)nxt, (SnmpHandler)this);
        }
        catch (Exception e) {
            m_log.error((Object)"InternalError ", (Throwable)e);
            this.m_dataTable.clear();
            SnmpSession snmpSession = session;
            synchronized (snmpSession) {
                this.m_errorCode = 2;
                this.m_message = e.getMessage();
                session.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
        String message = "InternalError. The error code is " + err + ". IP:" + this.m_ipAddress + " OID:" + this.m_oidText[0];
        m_log.error((Object)("snmpInternalError():" + session.toString() + " " + message));
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            this.m_errorCode = 2;
            this.m_message = message;
            for (int j = 0; j < this.m_oidText.length; ++j) {
                this.removeTableValue(this.m_oidText[j]);
            }
            this.m_waitFlg = false;
            session.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
        SnmpVarBind[] bind = ((SnmpPduRequest)pdu).toVarBindArray();
        String ipAddress = session.getPeer().getPeer().toString();
        String message = "Polling failed at TimeoutError. IP:" + ipAddress + " OID:" + bind[0].getName();
        String addMessage = "";
        if (m_log.isDebugEnabled()) {
            for (int i = 1; i < bind.length; ++i) {
                addMessage = addMessage + "\n\t" + ipAddress + " " + bind[i].getName();
            }
            message = message + addMessage;
        }
        m_log.warn((Object)message);
        SnmpSession snmpSession = session;
        synchronized (snmpSession) {
            this.m_errorCode = 1;
            this.m_message = message;
            for (int j = 0; j < this.m_oidText.length; ++j) {
                this.removeTableValue(this.m_oidText[j]);
            }
            session.notify();
        }
    }

    private void removeTableValue(String oidText) {
        Set oidSet = this.m_dataTable.keySet();
        String[] fullOids = oidSet.toArray(new String[oidSet.size()]);
        for (int i = 0; i < fullOids.length; ++i) {
            String fullOid = fullOids[i];
            if (!fullOid.startsWith(oidText)) continue;
            this.m_dataTable.removeValue(fullOid);
        }
    }

    public static void main(String[] args) {
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(args[0]);
        }
        catch (UnknownHostException e) {
            m_log.error((Object)e, (Throwable)e);
            return;
        }
        SnmpPoller poller = new SnmpPoller();
        int port = Integer.parseInt(args[1]);
        int version = Integer.parseInt(args[2]);
        String comunity = args[3];
        int retries = Integer.parseInt(args[4]);
        int timeout = Integer.parseInt(args[5]);
        boolean indexCheckFlg = Boolean.parseBoolean(args[6]);
        ArrayList<String> oids = new ArrayList<String>();
        for (int i = 7; i < args.length; ++i) {
            oids.add(args[i]);
        }
        DataTable dataTable = new DataTable();
        poller.polling(ipAddress, port, version, comunity, retries, timeout, oids, indexCheckFlg, dataTable);
        Set keyset = dataTable.keySet();
        TreeSet keys = new TreeSet(keyset);
        Iterator keyItr = keys.iterator();
        TreeSet<ValueObject> ts = new TreeSet<ValueObject>();
        while (keyItr.hasNext()) {
            ts.add(dataTable.getValue((String)keyItr.next()));
        }
        Iterator itr = ts.iterator();
        while (itr.hasNext()) {
            m_log.info(itr.next());
        }
    }
}

