/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sharedtable.bean;

import com.clustercontrol.sharedtable.bean.ValueObject;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
implements Cloneable {
    private final HashMap<String, ValueObject> m_hm;
    private long m_lastReference = 0L;
    private long m_lastReferenceInterval;

    public DataTable() {
        this.m_hm = new HashMap();
        this.m_lastReference = System.currentTimeMillis();
    }

    private DataTable(HashMap<String, ValueObject> hp, long lastReference) {
        this.m_hm = hp;
    }

    public synchronized void putValue(String key, long date, Object value) {
        this.m_hm.put(key, new ValueObject(key, date, value));
    }

    public synchronized void putValueAll(DataTable table) {
        this.m_hm.putAll(table.m_hm);
    }

    public synchronized void setValueAll(DataTable table) {
        this.m_hm.clear();
        this.m_hm.putAll(table.m_hm);
    }

    public synchronized ValueObject getValue(String key) {
        ValueObject vo = this.m_hm.get(key);
        long now = System.currentTimeMillis();
        this.m_lastReferenceInterval = now - this.m_lastReference;
        this.m_lastReference = now;
        return vo;
    }

    public synchronized ValueObject removeValue(String key) {
        return this.m_hm.remove(key);
    }

    public synchronized DataTable getValueAll() {
        DataTable st = (DataTable)this.clone();
        long now = System.currentTimeMillis();
        this.m_lastReferenceInterval = now - this.m_lastReference;
        this.m_lastReference = System.currentTimeMillis();
        return st;
    }

    protected Object clone() {
        DataTable st = new DataTable((HashMap)this.m_hm.clone(), this.m_lastReference);
        return st;
    }

    public long getLastReference() {
        return this.m_lastReference;
    }

    public long getLastReferenceInterval() {
        return this.m_lastReferenceInterval;
    }

    public Set keySet() {
        return this.m_hm.keySet();
    }

    public void putValue(ValueObject entry) {
        this.m_hm.put(entry.getKey(), entry);
    }

    public void clear() {
        this.m_hm.clear();
    }
}

