/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SARDeployerMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceMBean;
import org.jboss.util.Classes;

public class ServiceMBeanSupport
extends JBossNotificationBroadcasterSupport
implements ServiceMBean,
MBeanRegistration {
    public static final String[] SERVICE_CONTROLLER_SIG = new String[]{ObjectName.class.getName()};
    protected Logger log;
    protected MBeanServer server;
    protected ObjectName serviceName;
    private int state = 7;
    private boolean isJBossInternalLifecycleExposed = false;

    public ServiceMBeanSupport() {
        this.log = Logger.getLogger((String)this.getClass().getName());
        this.log.trace((Object)"Constructing");
    }

    public ServiceMBeanSupport(Class type) {
        this(type.getName());
    }

    public ServiceMBeanSupport(String category) {
        this(Logger.getLogger((String)category));
    }

    public ServiceMBeanSupport(Logger log) {
        this.log = log;
        log.trace((Object)"Constructing");
    }

    public String getName() {
        return Classes.stripPackageName((String)this.log.getName());
    }

    public ObjectName getServiceName() {
        return this.serviceName;
    }

    public DeploymentInfo getDeploymentInfo() throws JMException {
        Object[] args = new Object[]{this.serviceName};
        String[] sig = new String[]{this.serviceName.getClass().getName()};
        DeploymentInfo sdi = (DeploymentInfo)this.server.invoke(SARDeployerMBean.OBJECT_NAME, "getService", args, sig);
        return sdi;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return states[this.state];
    }

    public Logger getLog() {
        return this.log;
    }

    public void create() throws Exception {
        if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
            this.server.invoke(ServiceController.OBJECT_NAME, "create", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
        } else {
            this.jbossInternalCreate();
        }
    }

    public void start() throws Exception {
        if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
            this.server.invoke(ServiceController.OBJECT_NAME, "start", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
        } else {
            this.jbossInternalStart();
        }
    }

    public void stop() {
        try {
            if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
                this.server.invoke(ServiceController.OBJECT_NAME, "stop", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
            } else {
                this.jbossInternalStop();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in stop " + this.jbossInternalDescription()), t);
        }
    }

    public void destroy() {
        try {
            if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
                this.server.invoke(ServiceController.OBJECT_NAME, "destroy", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
            } else {
                this.jbossInternalDestroy();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in destroy " + this.jbossInternalDescription()), t);
        }
    }

    protected String jbossInternalDescription() {
        if (this.serviceName != null) {
            return this.serviceName.toString();
        }
        return this.getName();
    }

    public void jbossInternalLifecycle(String method) throws Exception {
        if (method == null) {
            throw new IllegalArgumentException("Null method name");
        }
        if (method.equals("create")) {
            this.jbossInternalCreate();
        } else if (method.equals("start")) {
            this.jbossInternalStart();
        } else if (method.equals("stop")) {
            this.jbossInternalStop();
        } else if (method.equals("destroy")) {
            this.jbossInternalDestroy();
        } else {
            throw new IllegalArgumentException("Unknown lifecyle method " + method);
        }
    }

    protected void jbossInternalCreate() throws Exception {
        this.log.debug((Object)("Creating " + this.jbossInternalDescription()));
        try {
            this.createService();
            this.state = 6;
        }
        catch (Exception e) {
            this.log.debug((Object)("Initialization failed " + this.jbossInternalDescription()), (Throwable)e);
            throw e;
        }
        this.log.debug((Object)("Created " + this.jbossInternalDescription()));
    }

    protected void jbossInternalStart() throws Exception {
        if (this.state == 2 || this.state == 3 || this.state == 1) {
            return;
        }
        if (this.state != 6 && this.state != 0 && this.state != 4) {
            this.log.debug((Object)"Start requested before create, calling create now");
            this.create();
        }
        this.state = 2;
        this.sendStateChangeNotification(0, 2, this.getName() + " starting", null);
        this.log.debug((Object)("Starting " + this.jbossInternalDescription()));
        try {
            this.startService();
        }
        catch (Exception e) {
            this.state = 4;
            this.sendStateChangeNotification(2, 4, this.getName() + " failed", e);
            this.log.debug((Object)("Starting failed " + this.jbossInternalDescription()), (Throwable)e);
            throw e;
        }
        this.state = 3;
        this.sendStateChangeNotification(2, 3, this.getName() + " started", null);
        this.log.debug((Object)("Started " + this.jbossInternalDescription()));
    }

    protected void jbossInternalStop() {
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        this.sendStateChangeNotification(3, 1, this.getName() + " stopping", null);
        this.log.debug((Object)("Stopping " + this.jbossInternalDescription()));
        try {
            this.stopService();
        }
        catch (Throwable e) {
            this.state = 4;
            this.sendStateChangeNotification(1, 4, this.getName() + " failed", e);
            this.log.warn((Object)("Stopping failed " + this.jbossInternalDescription()), e);
            return;
        }
        this.state = 0;
        this.sendStateChangeNotification(1, 0, this.getName() + "stopped", null);
        this.log.debug((Object)("Stopped " + this.jbossInternalDescription()));
    }

    protected void jbossInternalDestroy() {
        if (this.state == 5) {
            return;
        }
        if (this.state == 3) {
            this.log.debug((Object)"Destroy requested before stop, calling stop now");
            this.stop();
        }
        this.log.debug((Object)("Destroying " + this.jbossInternalDescription()));
        try {
            this.destroyService();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Destroying failed " + this.jbossInternalDescription()), t);
        }
        this.state = 5;
        this.log.debug((Object)("Destroyed " + this.jbossInternalDescription()));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = this.getObjectName(server, name);
        return this.serviceName;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.log.info((Object)"Registration is not done -> stop");
            this.stop();
        } else {
            this.state = 8;
            try {
                MBeanInfo info = this.server.getMBeanInfo(this.serviceName);
                MBeanOperationInfo[] ops = info.getOperations();
                for (int i = 0; i < ops.length; ++i) {
                    if (ops[i] == null || !"jbossInternalLifecycle".equals(ops[i].getName())) continue;
                    this.isJBossInternalLifecycleExposed = true;
                    break;
                }
            }
            catch (Throwable t) {
                this.log.warn((Object)("Unexcepted error accessing MBeanInfo for " + this.serviceName), t);
            }
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        try {
            if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
                this.server.invoke(ServiceController.OBJECT_NAME, "remove", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Unexpected error during removal. " + this.serviceName), t);
        }
        this.server = null;
        this.serviceName = null;
        this.state = 7;
    }

    protected long getNextNotificationSequenceNumber() {
        return this.nextNotificationSequenceNumber();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name;
    }

    protected void createService() throws Exception {
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
    }

    private void sendStateChangeNotification(int oldState, int newState, String msg, Throwable t) {
        long now = System.currentTimeMillis();
        AttributeChangeNotification stateChangeNotification = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, msg, "State", "java.lang.Integer", new Integer(oldState), new Integer(newState));
        stateChangeNotification.setUserData(t);
        this.sendNotification(stateChangeNotification);
    }
}

