/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.forward;

import com.clustercontrol.syslogng.forward.MessageInfo;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageParser {
    private static MessageFormat m_msgfmt = new MessageFormat("<{0}>{1,date,MMM dd HH:mm:ss} {2} {3}", Locale.ENGLISH);
    private static MessageFormat m_datefmt = new MessageFormat("{0,date,yyyyMMMddHH:mm:ss}", Locale.ENGLISH);
    private static final int INDEX_PRI = 0;
    private static final int INDEX_DATE = 1;
    private static final int INDEX_HOST = 2;
    private static final int INDEX_MSG = 3;
    private static final int INDEX_SPLIT_PRI = 0;
    private static final int INDEX_SPLIT_DAY = 1;
    private static final int INDEX_SPLIT_TIME = 2;
    static Log log = LogFactory.getLog(MessageParser.class);

    public static MessageInfo parse(String msg) {
        Object[] parseArgs = null;
        Object[] parseDate = null;
        Date messageDate = null;
        String[] splitMsgs = msg.split("\\s+");
        String msgMonth = splitMsgs[0].split(">")[1];
        String msgDay = splitMsgs[1];
        String msgTime = splitMsgs[2];
        if (msgDay.length() == 1) {
            msgDay = "0" + msgDay;
        }
        Calendar nowDate = Calendar.getInstance();
        Integer nowYear = nowDate.get(1);
        String dateString = nowYear.toString() + msgMonth + msgDay + msgTime;
        try {
            parseDate = m_datefmt.parse(dateString);
            messageDate = (Date)parseDate[0];
            parseArgs = m_msgfmt.parse(msg);
        }
        catch (ParseException e) {
            log.error((Object)msg, (Throwable)e);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"parsed msg");
            log.debug((Object)messageDate);
            for (int i = 2; i < parseArgs.length; ++i) {
                log.debug(parseArgs[i]);
            }
        }
        MessageInfo logMessage = new MessageInfo();
        logMessage.setHostName((String)parseArgs[2]);
        logMessage.setMessage((String)parseArgs[3]);
        logMessage.setGenerationDate(MessageParser.setYear(messageDate));
        return logMessage;
    }

    private static Date setYear(Date date) {
        Calendar nowDate = Calendar.getInstance();
        Calendar dataDate = Calendar.getInstance();
        dataDate.setTime(date);
        int monthNow = nowDate.get(2);
        int monthdat = dataDate.get(2);
        int year = nowDate.get(1);
        if (monthdat == 11 && monthNow == 0) {
            --year;
        }
        dataDate.set(1, year);
        log.debug((Object)dataDate.getTime().toString());
        return dataDate.getTime();
    }
}

