/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.forward;

import com.clustercontrol.syslogng.forward.LogManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogForward {
    private LogManager m_manageLog;
    static Log log = LogFactory.getLog(LogForward.class);

    public static void main(String[] args) throws Exception {
        log.debug((Object)"Start");
        LogForward logForward = new LogForward(args[0]);
        try {
            logForward.forward();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        System.exit(0);
        log.debug((Object)"End");
    }

    LogForward(String propFileName) throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream(propFileName));
        this.m_manageLog = new LogManager(props);
        this.m_manageLog.start();
        while (!this.m_manageLog.isWaiting()) {
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LogForward.this.m_manageLog.interrupt();
            }
        });
    }

    private void put(String msg) {
        if (msg == null || msg.equals("")) {
            return;
        }
        log.debug((Object)("put Message:" + msg));
        this.m_manageLog.add(msg);
    }

    public void forward() throws Exception {
        log.debug((Object)"Read InputStaream");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                this.put(br.readLine());
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            this.m_manageLog.interrupt();
            return;
        }
    }
}

