/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.accesscontrol.util.TimeKeeper;
import com.clustercontrol.accesscontrol.util.TimeKeeperService;
import com.clustercontrol.repository.dao.FacilityTreeDAO;
import com.clustercontrol.repository.ejb.entity.FacilityTreeBean;
import com.clustercontrol.repository.ejb.entity.FacilityTreePK;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FacilityTreeDAOImpl
implements FacilityTreeDAO {
    protected static Log m_log = LogFactory.getLog(FacilityTreeDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    public static final String BASE_DN = "ou=facilitytree";
    protected static final String OBJECT_CLASS_FACILITY_TREE = "ccFacilityTree";
    private static int MAX_RETRY = 3;

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(FacilityTreePK pk, FacilityTreeBean ejb) throws EJBException {
        m_log.trace((Object)("load() : start " + pk.getDn()));
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                this.clearBean(ejb);
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                ejb.setDn(pk.getDn());
                ejb.setFacilityId((String)attrs.get("ccFacilityId").get(0));
                ejb.setTreeType(new Integer((String)attrs.get("ccTreeType").get(0)));
                ejb.setBuiltIn(new Boolean((String)attrs.get("ccFacilityBuiltIn").get(0)));
                ejb.setSortValue(new Integer((String)attrs.get("ccFacilitySortValue").get(0)));
                m_log.debug((Object)("load() : Dn " + pk.getDn() + " FacilityId " + ejb.getFacilityId() + " TreeType " + ejb.getTreeType()));
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("load(): catch NamingException" + ex.getMessage()));
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"load() : LDAP query result is null");
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("load() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            m_log.trace((Object)("load() : end " + pk.getDn()));
            return;
        }
    }

    public void store(FacilityTreeBean ejb) throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FacilityTreePK pk) throws RemoveException, EJBException {
        m_log.trace((Object)("remove() : start " + pk.getDn()));
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                ctx.destroySubcontext(pk.getDn());
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("remove(): catch NamingException" + ex.getMessage()));
                if (++retryCount < MAX_RETRY) continue;
                AplLogger apllog = new AplLogger("REP", "rep");
                Object[] args = new String[]{pk.getDn()};
                apllog.put("SYS", "008", args);
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"remove() : LDAP query result is null");
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("remove() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            m_log.trace((Object)("remove() : end " + pk.getDn()));
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public FacilityTreePK create(FacilityTreeBean ejb) throws CreateException, EJBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection findAll() throws FinderException {
        return this.findAll(null, null);
    }

    public Collection findAll(String facilityId) throws FinderException {
        return this.findAll(facilityId, null);
    }

    public Collection findAllNode(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(1));
    }

    public Collection findAllScope(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAll(String facilityId, Integer type) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findAll() : FacilityId = " + facilityId + ", Type = " + type));
        StringBuffer baseDn = new StringBuffer();
        if (facilityId == null || facilityId.compareTo("") == 0) {
            baseDn.append(BASE_DN);
        } else {
            try {
                FacilityTreePK pk = this.findScopeByFacilityId(facilityId);
                baseDn.append(pk.getDn());
            }
            catch (FinderException e) {
                m_log.debug((Object)("findAllScope() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                m_log.debug((Object)("findAllScope() :" + e.getMessage()));
                return ret;
            }
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        if (type != null && type == 1) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(1);
        } else if (type != null && type == 0) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(0);
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(baseDn.toString(), search.toString(), constraints);
                if (results == null) {
                    m_log.debug((Object)("findAll() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK pk = null;
                    pk = aResult.getName().compareTo("") == 0 ? new FacilityTreePK(baseDn.toString()) : new FacilityTreePK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findAllScope() : " + ex.getMessage()));
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException e) {
                m_log.debug((Object)"findAllScope() : LDAP query result is null");
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)e);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findAll() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacilityTreePK findByPrimaryKey(FacilityTreePK pk) throws FinderException {
        Context ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer;
            block22: {
                timer = null;
                m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                Attributes attrs = ctx.getAttributes(pk.getDn());
                if (attrs == null) break block22;
                FacilityTreePK facilityTreePK = pk;
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                return facilityTreePK;
            }
            try {
                throw new FinderException("FacilityTreeDAOImpl.findByPrimaryKey() : dn=" + pk.getDn() + " not found.");
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
                if (++retryCount >= MAX_RETRY) {
                    throw new EJBException((Exception)ex);
                }
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
            }
            catch (NullPointerException ex) {
                block23: {
                    try {
                        m_log.debug((Object)"findByPrimaryKey() : LDAP query result is null");
                        if (++retryCount < MAX_RETRY) break block23;
                        throw new EJBException((Exception)ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e) {
                            m_log.error((Object)("findByPrimaryKey() context close failed : " + e.getMessage()));
                        }
                        TimeKeeperService.stop(timer);
                        throw throwable;
                    }
                }
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findByPrimaryKey() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findChildren(FacilityTreePK pk) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findChildren() : dn = " + pk.getDn()));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(pk.getDn(), search.toString(), constraints);
                if (results == null) {
                    m_log.warn((Object)("findChildren() : No Search Result : dn = " + pk.getDn()));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK p = new FacilityTreePK(aResult.getName() + "," + pk.getDn());
                    ret.add(p);
                }
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findChildren() : " + ex.getMessage()));
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException ex) {
                m_log.debug((Object)"findChildren() : LDAP query result is null");
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findChildren() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacilityTreePK findScopeByFacilityId(String facilityId) throws FinderException {
        m_log.debug((Object)("findScopeByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append(")(");
        search.append("ccFacilityId");
        search.append("=");
        search.append(facilityId);
        search.append(")(");
        search.append("ccTreeType");
        search.append("=");
        search.append(0);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        FacilityTreePK pk = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(BASE_DN, search.toString(), constraints);
                if (results == null) {
                    throw new FinderException("FacilityTreeDAOImpl.findScopeByFacilityId() : FacilityId=" + facilityId + " not found.");
                }
                SearchResult aResult = null;
                Attributes attrs = null;
                if (results.hasMoreElements()) {
                    aResult = (SearchResult)results.nextElement();
                    attrs = aResult.getAttributes();
                }
                if (attrs == null) {
                    throw new FinderException("FacilityTreeDAOImpl.findScopeByFacilityId() : FacilityId=" + facilityId + " not found.");
                }
                pk = new FacilityTreePK(aResult.getName() + "," + BASE_DN);
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findScopeByFacilityId() : " + ex.getMessage()));
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException ex) {
                m_log.debug((Object)"findScopeByFacilityId() : LDAP query result is null");
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findScopeByFacilityId() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return pk;
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append(")(");
        search.append("ccFacilityId");
        search.append("=");
        search.append(facilityId);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(BASE_DN, search.toString(), constraints);
                if (results == null) {
                    m_log.warn((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK pk = new FacilityTreePK(aResult.getName() + "," + BASE_DN);
                    ret.add(pk);
                }
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findByFacilityId() : " + ex.getMessage()));
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException ex) {
                m_log.debug((Object)"findByFacilityId() : LDAP query result is null");
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findByFacilityId() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return ret;
        }
        LdapConnectionManager.getConnectionManager().setDirContext(null);
        throw new FinderException("findByFacilityId() : LDAP query result is null for many times");
    }

    public Collection findOneLevel() throws FinderException {
        return this.findOneLevel(null, null);
    }

    public Collection findOneLevel(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, null);
    }

    public Collection findOneLevelNode(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, new Integer(1));
    }

    public Collection findOneLevelScope(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findOneLevel(String facilityId, Integer type) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findOneLevel() : FacilityId = " + facilityId + ", Type = " + type));
        StringBuffer baseDn = new StringBuffer();
        if (facilityId == null || facilityId.compareTo("") == 0) {
            baseDn.append(BASE_DN);
        } else {
            try {
                FacilityTreePK pk = this.findScopeByFacilityId(facilityId);
                baseDn.append(pk.getDn());
            }
            catch (FinderException e) {
                m_log.warn((Object)("findOneLevel() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                return ret;
            }
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        if (type != null && type == 1) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(1);
        } else if (type != null && type == 0) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(0);
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        int retryCount = 0;
        while (MAX_RETRY > retryCount) {
            TimeKeeper timer = null;
            try {
                ctx = LdapConnectionManager.getConnectionManager().getDirContext();
                timer = TimeKeeperService.start();
                results = ctx.search(baseDn.toString(), search.toString(), constraints);
                if (results == null) {
                    m_log.warn((Object)("findOneLevel() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                    ArrayList<FacilityTreePK> arrayList = ret;
                    return arrayList;
                }
                while (results.hasMoreElements()) {
                    SearchResult aResult = (SearchResult)results.nextElement();
                    FacilityTreePK pk = new FacilityTreePK(aResult.getName() + "," + baseDn.toString());
                    ret.add(pk);
                }
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findOneLevel() : " + ex.getMessage()));
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            catch (NullPointerException ex) {
                m_log.debug((Object)"findOneLevel() : LDAP query result is null");
                ret.clear();
                if (++retryCount < MAX_RETRY) continue;
                throw new EJBException((Exception)ex);
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {
                    m_log.error((Object)("findOneLevel() context close failed : " + e.getMessage()));
                }
                TimeKeeperService.stop((TimeKeeper)timer);
                continue;
            }
            return ret;
        }
        return ret;
    }

    protected void clearBean(FacilityTreeBean ejb) {
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setParentFacilityId(null);
        ejb.setTreeType(null);
    }
}

