/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.commons.util;

import com.clustercontrol.commons.util.JNDIConnectionManager;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
    protected static Log m_log = LogFactory.getLog(ConnectionManager.class);
    private static ConnectionManager instance = null;
    private InitialContext ctx;
    private DataSource ds;

    public static synchronized ConnectionManager getConnectionManager() throws SQLException {
        if (instance == null) {
            instance = new ConnectionManager();
        }
        return instance;
    }

    private ConnectionManager() throws SQLException {
        try {
            this.ctx = JNDIConnectionManager.getInitialContext();
            Properties properties = new Properties();
            try {
                String homedir = System.getProperty("jboss.server.home.dir");
                String propertyFile = homedir + File.separator + "conf" + File.separator + "performance.properties";
                properties.load(new FileInputStream(propertyFile));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.ds = (DataSource)this.ctx.lookup(properties.getProperty("DataSource"));
        }
        catch (NamingException e1) {
            throw new SQLException(e1.getMessage());
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }
}

