/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.AgentThread;
import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandThread
extends AgentThread {
    protected String m_resultMsg = "";
    protected String m_errMsg = "";
    protected int m_exitValue;
    private static Log log = LogFactory.getLog(CommandThread.class);
    private static final Object lockNewProcess = new Object();

    public static void main(String[] args) {
        CommandThread agent = new CommandThread();
        agent.execCommand(new String[]{"java -version"});
        agent.execCommand(new String[]{"cmd /c \"dir c;\\ /s \" "});
        agent.execCommand(new String[]{"notepad"});
    }

    public CommandThread() {
    }

    public CommandThread(RunInstructionInfo info, SendQueue sendQueue, Hashtable<String, Date> runHistory, Properties props) {
        super(info, sendQueue, runHistory, props);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        log.debug((Object)"run start");
        Date startDate = new Date();
        RunHistoryUtil.addRunHistory(this.m_info, this.m_runHistory, startDate);
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(this.m_info.getSessionId());
        info.setJobId(this.m_info.getJobId());
        info.setFacilityId(this.m_info.getFacilityId());
        info.setCommand(this.m_info.getCommand());
        info.setCommandType(this.m_info.getCommandType());
        info.setStatus(0);
        info.setTime(startDate);
        log.info((Object)("run SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId()));
        this.m_sendQueue.put(info);
        String sysUserName = System.getProperty("user.name");
        String execCommand = this.m_info.getCommand();
        String[] cmd = null;
        if (!sysUserName.equals(this.m_info.getUser())) {
            if (!sysUserName.equals("root")) {
                info.setStatus(2);
                info.setTime(new Date());
                String errMsg = "The execution user of the command and agent's user are different. execUser=[" + this.m_info.getUser() + "], agentUser=[" + sysUserName + "]";
                info.setErrorMessage(errMsg);
                info.setMessage("");
                this.m_sendQueue.put(info);
                log.error((Object)errMsg);
                log.info((Object)"run end");
                this.sendDeleteHistory(info);
                return;
            }
            cmd = new String[]{"su", this.m_info.getUser(), "-c", execCommand};
        } else {
            cmd = execCommand.split(" ");
        }
        boolean ret = this.execCommand(cmd);
        if (ret) {
            info.setStatus(1);
            info.setEndValue(this.m_exitValue);
        } else {
            info.setStatus(2);
        }
        info.setTime(new Date());
        info.setErrorMessage(this.m_errMsg);
        info.setMessage(this.m_resultMsg);
        this.m_sendQueue.put(info);
        this.sendDeleteHistory(info);
        log.debug((Object)"run end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execCommand(String[] cmd) {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            if (log.isInfoEnabled()) {
                for (int i = 0; i < cmd.length; ++i) {
                    log.info((Object)("Command Execute:" + cmd[i]));
                }
            }
            Object i = lockNewProcess;
            synchronized (i) {
                process = runtime.exec(cmd);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            this.m_errMsg = e.getMessage();
            return false;
        }
        try {
            StreamReader errStreamReader = new StreamReader(process.getErrorStream());
            errStreamReader.start();
            StreamReader inStreamReader = new StreamReader(process.getInputStream());
            inStreamReader.start();
            try {
                this.m_exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                this.m_errMsg = e.getMessage();
                boolean bl = false;
                process.destroy();
                return bl;
            }
            log.debug((Object)("ExitCode:" + this.m_exitValue));
            try {
                inStreamReader.join();
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            this.m_resultMsg = inStreamReader.getResult();
            log.debug((Object)inStreamReader.getResult());
            try {
                errStreamReader.join();
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            this.m_errMsg = errStreamReader.getResult();
            log.debug((Object)this.m_errMsg);
            boolean bl = true;
            return bl;
        }
        finally {
            process.destroy();
        }
    }

    protected class StreamReader
    extends Thread {
        InputStream m_ist;
        StringBuffer m_result;
        String out_string = "";
        byte[] m_readbuf;

        public StreamReader(InputStream ist) {
            this.m_ist = ist;
            this.m_result = new StringBuffer();
            this.m_readbuf = new byte[CommandThread.this.m_limit_orgmsg];
        }

        public void run() {
            boolean bufIsFull = false;
            int readSize = 0;
            int total = 0;
            log.debug((Object)"--- read start ---");
            try {
                while ((readSize = this.m_ist.read(this.m_readbuf, total, CommandThread.this.m_limit_orgmsg - total)) != -1) {
                    log.debug((Object)("total : " + total + ", readsize : " + readSize));
                    if (bufIsFull) {
                        total = 0;
                        continue;
                    }
                    if (total >= CommandThread.this.m_limit_orgmsg) {
                        log.info((Object)("stdout / errout limit(" + CommandThread.this.m_limit_orgmsg + " Byte) over"));
                        this.out_string = new String(this.m_readbuf);
                        bufIsFull = true;
                        continue;
                    }
                    total += readSize;
                }
                if (!bufIsFull) {
                    this.out_string = new String(this.m_readbuf, 0, total);
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            log.debug((Object)"--- read end ---");
            try {
                this.m_ist.close();
            }
            catch (IOException e) {
                log.info((Object)e.getMessage());
            }
        }

        public String getResult() {
            return this.out_string;
        }
    }
}

