/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logagent;

import com.clustercontrol.logagent.util.InternalLogger;
import com.clustercontrol.monitor.message.LogOutputInfo;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueue
implements ExceptionListener {
    private static final String QUEUE_CON_FACTORY = "ConnectionFactory";
    private static final String QUEUE_USER_NAME = "queue.user.name";
    private static final String QUEUE_USER_PASSWORD = "queue.user.password";
    private static final long SEND_TIMEOUT = 60000L;
    private Properties m_props;
    private QueueConnection m_con;
    private Queue m_queueLog;
    private Queue m_queueFacility;
    private QueueSession m_session;
    private QueueConnectionFactory m_factory;
    private boolean m_isErr = false;
    private long m_interval = 10000L;
    private static Log log = LogFactory.getLog(SendQueue.class);
    private Object reInitialLock = new Object();
    private volatile boolean internalErroInhibitflag = false;

    public SendQueue(Properties props) {
        this.m_props = props;
        String interval = this.m_props.getProperty("receivetopic.reconnection.interval");
        if (interval != null) {
            try {
                this.m_interval = Integer.parseInt(interval) * 1000;
            }
            catch (NumberFormatException e) {
                log.error((Object)"receivetopic.reconnection.interval", (Throwable)e);
            }
        }
        this.initial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reInitial() {
        Object object = this.reInitialLock;
        synchronized (object) {
            boolean ret = false;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
            this.terminate();
            if (this.initial()) {
                ret = true;
                log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
                this.m_isErr = false;
            } else {
                log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
            }
            return ret;
        }
    }

    public void terminate() {
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(Object info) {
        log.debug((Object)("put() start : " + info.toString()));
        ExecutorService es = null;
        Future<Boolean> task = null;
        try {
            String id = "";
            id = info instanceof LogOutputInfo ? ((LogOutputInfo)info).getMonitorId() : info.toString();
            SenderThreadFactory threadFactory = new SenderThreadFactory(id);
            es = Executors.newSingleThreadExecutor(threadFactory);
            task = es.submit(new Sender(info));
            task.get(60000L, TimeUnit.MILLISECONDS);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (this.internalErroInhibitflag) {
                log.error((Object)"Failed to connect to MGR");
            } else {
                log.error((Object)"Failed to connect to MGR", (Throwable)e);
            }
            if (!this.internalErroInhibitflag) {
                InternalLogger.error("hinemos_logagent: Failed to connect to MGR");
                this.internalErroInhibitflag = true;
            }
        }
        finally {
            log.debug((Object)("put() end   : " + info.toString()));
            if (es != null) {
                es.shutdown();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (QueueConnectionFactory)con.lookup(QUEUE_CON_FACTORY);
            this.m_con = this.m_props.getProperty(QUEUE_USER_NAME) != null ? this.m_factory.createQueueConnection(this.m_props.getProperty(QUEUE_USER_NAME), this.m_props.getProperty(QUEUE_USER_PASSWORD)) : this.m_factory.createQueueConnection();
            this.m_session = this.m_con.createQueueSession(false, 1);
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.m_queueLog = (Queue)con.lookup("queue/clustercontrol/Monitor/EventLog");
            this.m_queueFacility = (Queue)con.lookup("queue/clustercontrol/Logtransfer/LogTransferFileManage");
        }
        catch (Exception e) {
            log.error((Object)"Init", (Throwable)e);
            this.m_isErr = true;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e1) {}
        }
        this.internalErroInhibitflag = false;
        return true;
    }

    public void onException(JMSException arg0) {
        log.error((Object)arg0.getMessage(), (Throwable)arg0);
        this.m_isErr = true;
        this.terminate();
    }

    private class SenderThreadFactory
    implements ThreadFactory {
        private final String m_threadName;

        public SenderThreadFactory(String threadName) {
            this.m_threadName = threadName;
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "Sender-" + this.m_threadName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Sender
    implements Callable<Boolean> {
        private Object m_info;

        public Sender(Object info) {
            this.m_info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            if (SendQueue.this.m_isErr) {
                SendQueue.this.reInitial();
            }
            QueueSender sender = null;
            ObjectMessage mess = null;
            while (true) {
                Boolean loginfo;
                try {
                    if (this.m_info instanceof LogOutputInfo) {
                        sender = SendQueue.this.m_session.createSender(SendQueue.this.m_queueLog);
                        mess = SendQueue.this.m_session.createObjectMessage((Serializable)((LogOutputInfo)this.m_info));
                        if (log.isDebugEnabled()) {
                            loginfo = (LogOutputInfo)this.m_info;
                            log.debug((Object)("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1! : Facility ID : " + loginfo.getFacilityId() + ", " + "Monitor ID : " + loginfo.getMonitorId() + ", " + "Priority : " + loginfo.getPriority() + ", " + "Message ID : " + loginfo.getMessageId() + ", " + "Message : " + loginfo.getMessage()));
                        }
                    } else if (this.m_info instanceof String) {
                        sender = SendQueue.this.m_session.createSender(SendQueue.this.m_queueFacility);
                        mess = SendQueue.this.m_session.createTextMessage((String)this.m_info);
                        log.debug((Object)("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1! : notify Fasility ID : " + this.m_info));
                    } else {
                        loginfo = false;
                        return loginfo;
                    }
                    sender.send((Message)mess);
                    loginfo = true;
                }
                catch (JMSException e) {
                    log.error((Object)e);
                    log.info((Object)"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30ea\u30c8\u30e9\u30a4");
                    try {
                        Thread.sleep(SendQueue.this.m_interval);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (SendQueue.this.reInitial()) continue;
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (sender == null) continue;
                        sender.close();
                    }
                    catch (Exception e1) {}
                    continue;
                }
                return loginfo;
                break;
            }
        }
    }
}

