/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.util;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerUtil;
import com.clustercontrol.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendMail {
    protected static Log m_log = LogFactory.getLog(SendMail.class);
    private static final String SUBJECT_DATE_FORMAT = "MM/dd HH:mm:ss";
    private static String FROM_ADDRESS = null;
    private static String FROM_PERSONAL_NAME = null;
    private static String REPLY_TO_ADDRESS = null;
    private static String REPLY_TO_PERSONAL_NAME = null;
    private static String ERRORS_TO_ADDRESS = null;
    private static int RETRY_COUNT = 0;
    private Locale m_local = Locale.getDefault();

    public boolean sendMail(String[] address, LogOutputInfo source, Date timeStamp) throws NamingException, MessagingException, UnsupportedEncodingException, CreateException, FinderException {
        if (address == null || address.length <= 0) {
            return false;
        }
        InitialContext initialContext = null;
        try {
            InternetAddress[] toAddress;
            InternetAddress[] reply;
            initialContext = new InitialContext();
            boolean retryFlg = true;
            Session session = (Session)initialContext.lookup("java:/Mail");
            MimeMessage mes = new MimeMessage(session);
            if (FROM_ADDRESS != null && FROM_PERSONAL_NAME != null) {
                mes.setFrom((Address)new InternetAddress(FROM_ADDRESS, FROM_PERSONAL_NAME, "iso-2022-jp"));
            } else if (FROM_ADDRESS != null && FROM_PERSONAL_NAME == null) {
                mes.setFrom((Address)new InternetAddress(FROM_ADDRESS));
            }
            if (REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME != null) {
                reply = new InternetAddress[]{new InternetAddress(REPLY_TO_ADDRESS, REPLY_TO_PERSONAL_NAME, "iso-2022-jp")};
                mes.setReplyTo((Address[])reply);
                mes.reply(true);
            } else if (REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME == null) {
                reply = new InternetAddress[]{new InternetAddress(REPLY_TO_ADDRESS)};
                mes.setReplyTo((Address[])reply);
                mes.reply(true);
            }
            if (ERRORS_TO_ADDRESS != null) {
                mes.setHeader("Errors-To", ERRORS_TO_ADDRESS);
            }
            if ((toAddress = this.getAddress(address)) == null || toAddress.length <= 0) {
                return false;
            }
            mes.setRecipients(Message.RecipientType.TO, (Address[])toAddress);
            mes.setSubject(MimeUtility.encodeText((String)this.getSubject(source), (String)"iso-2022-jp", (String)"B"));
            mes.setContent((Object)this.getText(source), "text/plain; charset=iso-2022-jp");
            mes.setSentDate(this.getSentDate(timeStamp));
            for (int i = 0; i < RETRY_COUNT + 1 && retryFlg; ++i) {
                try {
                    Transport.send((Message)mes);
                    retryFlg = false;
                    continue;
                }
                catch (MessagingException me) {
                    retryFlg = true;
                    if (i < RETRY_COUNT) {
                        m_log.debug((Object)"sendMail() : \u30e1\u30fc\u30eb\u518d\u9001\u4fe1\u51e6\u7406");
                        continue;
                    }
                    throw me;
                }
            }
            return true;
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
    }

    private InternetAddress[] getAddress(String[] address) {
        Object[] toAddress = null;
        Vector<InternetAddress> list = new Vector<InternetAddress>();
        if (address != null) {
            for (int index = 0; index < address.length; ++index) {
                try {
                    list.add(new InternetAddress(address[index]));
                    continue;
                }
                catch (AddressException ae) {
                    // empty catch block
                }
            }
            if (list.size() > 0) {
                toAddress = new InternetAddress[list.size()];
                list.copyInto(toAddress);
            }
        }
        return toAddress;
    }

    private String getSubject(LogOutputInfo source) throws CreateException, NamingException, FinderException {
        String subject = null;
        if (source instanceof LogOutputInfo) {
            if (source.getMailTemplateId() != null) {
                try {
                    MailTemplateInfoData mailData = MailTemplateControllerUtil.getLocalHome().create().getMailTemplateInfo(source.getMailTemplateId());
                    subject = this.substitution(mailData.getSubject(), source);
                }
                catch (CreateException e) {
                    throw e;
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (FinderException e) {
                    throw e;
                }
            } else {
                subject = Messages.getString((String)"mail.subject", (Locale)this.m_local) + "(" + PriorityConstant.typeToString((int)source.getPriority()) + ")";
            }
        }
        return subject;
    }

    private String getText(LogOutputInfo source) throws CreateException, NamingException, FinderException {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);
        if (source instanceof LogOutputInfo) {
            if (source.getMailTemplateId() != null) {
                try {
                    MailTemplateInfoData mailData = MailTemplateControllerUtil.getLocalHome().create().getMailTemplateInfo(source.getMailTemplateId());
                    buf.append(this.substitution(mailData.getBody(), source));
                }
                catch (CreateException e) {
                    throw e;
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (FinderException e) {
                    throw e;
                }
            } else {
                buf.append(Messages.getString((String)"generation.time", (Locale)this.m_local) + " : " + sdf.format(source.getGenerationDate()) + "\n");
                buf.append(Messages.getString((String)"application", (Locale)this.m_local) + " : " + source.getApplication() + "\n");
                buf.append(Messages.getString((String)"priority", (Locale)this.m_local) + " : " + PriorityConstant.typeToString((int)source.getPriority()) + "\n");
                buf.append(Messages.getString((String)"message", (Locale)this.m_local) + " : " + source.getMessage() + "\n");
                buf.append(Messages.getString((String)"scope", (Locale)this.m_local) + " : " + source.getScopeText() + "\n");
            }
        }
        return buf.toString();
    }

    public String substitution(String text, LogOutputInfo info) {
        SimpleDateFormat sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);
        String retText = text.replaceAll("\\$\\{APPLICATION\\}", this.toLiteral(info.getApplication()));
        retText = retText.replaceAll("\\$\\{FACILITY_ID\\}", this.toLiteral(info.getFacilityId()));
        retText = retText.replaceAll("\\$\\{MONITOR_ID\\}", this.toLiteral(info.getMonitorId()));
        retText = retText.replaceAll("\\$\\{GENERATION_DATE\\}", this.toLiteral(sdf.format(info.getGenerationDate())));
        retText = retText.replaceAll("\\$\\{PLUGIN_ID\\}", this.toLiteral(info.getPluginId()));
        retText = retText.replaceAll("\\$\\{PRIORITY\\}", this.toLiteral(PriorityConstant.typeToString((int)info.getPriority())));
        retText = retText.replaceAll("\\$\\{SCOPE\\}", this.toLiteral(info.getScopeText()));
        retText = retText.replaceAll("\\$\\{MESSAGE_ID\\}", this.toLiteral(info.getMessageId()));
        retText = retText.replaceAll("\\$\\{MESSAGE\\}", this.toLiteral(info.getMessage()));
        retText = retText.replaceAll("\\$\\{ORG_MESSAGE\\}", this.toLiteral(info.getMessageOrg()));
        return retText;
    }

    public String toLiteral(String text) {
        if (text == null) {
            return "";
        }
        if (text.indexOf(92) == -1 && text.indexOf(36) == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                buffer.append('\\');
                buffer.append('\\');
                continue;
            }
            if (c == '$') {
                buffer.append('\\');
                buffer.append('$');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private Date getSentDate(Date timeStamp) {
        if (timeStamp == null) {
            timeStamp = new Date();
        }
        return timeStamp;
    }

    static {
        Properties properties = new Properties();
        try {
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "mail.properties";
            properties.load(new FileInputStream(propertyFile));
            FROM_ADDRESS = properties.getProperty("from.address");
            FROM_PERSONAL_NAME = properties.getProperty("from.personal.name");
            REPLY_TO_ADDRESS = properties.getProperty("reply.to.address");
            REPLY_TO_PERSONAL_NAME = properties.getProperty("reply.personal.name");
            ERRORS_TO_ADDRESS = properties.getProperty("errors.to.address");
            RETRY_COUNT = Integer.parseInt(properties.getProperty("retry.count"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

