/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.composite.StatusListComposite;
import com.clustercontrol.monitor.ui.MonitorUIPlugin;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.ScopeListBaseView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class StatusView
extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.monitor.view.StatusView";
    private StatusListComposite tableComposite = null;
    private Property condition = null;

    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.tableComposite = new StatusListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);
        this.createContextMenu();
        this.update();
        IPreferenceStore store = MonitorUIPlugin.getDefault().getPreferenceStore();
        this.setInterval(store.getInt("stateUpdateCycle"));
        if (store.getBoolean("statusUpdateFlg")) {
            this.startAutoReload();
        }
        return this.tableComposite;
    }

    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.update();
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StatusView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tableComposite.getTable());
        this.tableComposite.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem deleteAction = (ActionContributionItem)toolbar.find("com.clustercontrol.monitor.view.action.StatusDeleteAction");
        manager.add(deleteAction.getAction());
    }

    public void update() {
        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        String facilityId = null;
        if (item != null) {
            facilityId = item.getData().getFacilityId();
        }
        if (this.condition == null) {
            if (facilityId == null) {
                this.getPathLabel().setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
                this.getPathLabel().pack();
            }
            this.tableComposite.update(facilityId);
        } else {
            this.getPathLabel().setText(Messages.getString((String)"filtered.list"));
            this.getPathLabel().pack();
            this.tableComposite.update(facilityId, this.condition);
        }
    }

    public void setCondition(Property condition) {
        this.condition = condition;
    }

    public void dispose() {
        super.dispose();
        this.setCondition(null);
    }
}

