/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.ejb.session;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.factory.AddMonitorProcess;
import com.clustercontrol.process.factory.DeleteMonitorProcess;
import com.clustercontrol.process.factory.ModifyMonitorProcess;
import com.clustercontrol.process.factory.SelectMonitorProcess;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MonitorProcessControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MonitorProcessControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addProcess(MonitorInfo info) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddMonitorProcess process = new AddMonitorProcess();
        return process.add(info, pri.getName());
    }

    public boolean modifyProcess(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyMonitorProcess process = new ModifyMonitorProcess();
        return process.modify(info, pri.getName());
    }

    public boolean deleteProcess(String monitorId) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        DeleteMonitorProcess process = new DeleteMonitorProcess();
        return process.delete("PROCESS", monitorId);
    }

    public MonitorInfo getProcess(String monitorId) throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorProcess process = new SelectMonitorProcess();
        MonitorInfo info = process.getMonitor("PROCESS", monitorId);
        return info;
    }

    public ArrayList getProcessList() throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorProcess process = new SelectMonitorProcess();
        ArrayList list = process.getMonitorList("PROCESS");
        return list;
    }

    public ArrayList getProcessListTableDefine(Locale local) {
        SelectMonitorProcess process = new SelectMonitorProcess();
        ArrayList tableDefine = process.getMonitorListTableDefine(local);
        return tableDefine;
    }
}

